/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.service;

import java.io.File;
import nl.jpoint.vertx.mod.cluster.command.InstallModule;
import nl.jpoint.vertx.mod.cluster.command.InvokeContainer;
import nl.jpoint.vertx.mod.cluster.command.ResolveSnapshotVersion;
import nl.jpoint.vertx.mod.cluster.command.RunModule;
import nl.jpoint.vertx.mod.cluster.command.StopModule;
import nl.jpoint.vertx.mod.cluster.command.UndeployModule;
import nl.jpoint.vertx.mod.cluster.request.ModuleRequest;
import nl.jpoint.vertx.mod.cluster.service.DeployService;
import nl.jpoint.vertx.mod.cluster.util.ModuleFileNameFilter;
import nl.jpoint.vertx.mod.cluster.util.ModuleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.shareddata.ConcurrentSharedMap;
import org.vertx.java.platform.PlatformLocator;
import org.vertx.java.platform.PlatformManager;

public class DeployModuleService
implements DeployService {
    private static final Logger LOG = LoggerFactory.getLogger(DeployModuleService.class);
    private final Vertx vertx;
    private final JsonObject config;
    private final PlatformManager platformManager;
    private final File modRoot;
    private final ConcurrentSharedMap<String, String> installedModules;

    public DeployModuleService(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
        this.platformManager = PlatformLocator.factory.createPlatformManager();
        this.modRoot = new File(config.getString("mod.root"));
        this.installedModules = this.vertx.sharedData().getMap("installed_modules");
    }

    @Override
    public boolean deploy(ModuleRequest deployRequest) {
        JsonObject runResult;
        RunModule runModCommand;
        ModuleVersion moduleInstalled;
        ResolveSnapshotVersion resolveVersion;
        JsonObject result;
        if (deployRequest.isSnapshot() && (result = (resolveVersion = new ResolveSnapshotVersion(this.config, "DeployRequest")).execute(deployRequest)).getBoolean("success").booleanValue()) {
            deployRequest.setSnapshotVersion(result.getString("version"));
        }
        if ((moduleInstalled = this.moduleInstalled(deployRequest)).equals((Object)ModuleVersion.ERROR)) {
            return false;
        }
        if (moduleInstalled.equals((Object)ModuleVersion.INSTALLED)) {
            if (deployRequest.restart()) {
                runModCommand = new RunModule();
                runModCommand.execute(deployRequest);
            }
            return true;
        }
        if (!moduleInstalled.equals((Object)ModuleVersion.INSTALLED)) {
            InstallModule installCommand;
            JsonObject installResult;
            if (deployRequest.isAsync()) {
                return true;
            }
            if (moduleInstalled.equals((Object)ModuleVersion.OLDER_VERSION)) {
                StopModule stopModuleCommand;
                JsonObject result2;
                if (!deployRequest.restart() && !(result2 = (stopModuleCommand = new StopModule(this.vertx, this.modRoot)).execute(deployRequest)).getBoolean("module_stopped").booleanValue()) {
                    return false;
                }
                UndeployModule undeployCommand = new UndeployModule(this.vertx, this.modRoot);
                undeployCommand.execute(deployRequest);
            }
            if (!(installResult = (installCommand = new InstallModule()).execute(deployRequest)).getBoolean("success").booleanValue()) {
                return false;
            }
        }
        if (!(runResult = (runModCommand = new RunModule()).execute(deployRequest)).getBoolean("success").booleanValue() && !deployRequest.isAsync()) {
            return false;
        }
        this.installedModules.put((Object)deployRequest.getMavenArtifactId(), (Object)(deployRequest.getSnapshotVersion() == null ? deployRequest.getVersion() : deployRequest.getSnapshotVersion()));
        LOG.info("[{} - {}]: Cleaning up after deploy", (Object)"DeployRequest", (Object)deployRequest.getId());
        return true;
    }

    private ModuleVersion moduleInstalled(ModuleRequest deployRequest) {
        if (!this.modRoot.exists()) {
            LOG.error("[{} - {}]: Module root {} Does not exist.", new Object[]{"DeployRequest", deployRequest.getId().toString(), this.modRoot});
            return ModuleVersion.ERROR;
        }
        int n = 0;
        String[] stringArray = this.modRoot.list(new ModuleFileNameFilter(deployRequest));
        int n2 = stringArray.length;
        if (n < n2) {
            String mod = stringArray[n];
            if (mod.equals(deployRequest.getModuleId()) && !deployRequest.isSnapshot()) {
                LOG.info("[{} - {}]: Module {} already installed.", new Object[]{"DeployRequest", deployRequest.getId().toString(), deployRequest.getModuleId()});
                return ModuleVersion.INSTALLED;
            }
            if (deployRequest.getSnapshotVersion().equals(this.installedModules.get((Object)deployRequest.getMavenArtifactId()))) {
                LOG.info("[{} - {}]: Same SNAPSHOT version ({}) of Module {} already installed.", new Object[]{"DeployRequest", deployRequest.getId(), deployRequest.getSnapshotVersion(), deployRequest.getModuleId()});
                return ModuleVersion.INSTALLED;
            }
            LOG.info("[{} - {}]: Older version of Module {} already installed.", new Object[]{"DeployRequest", deployRequest.getId().toString(), deployRequest.getModuleId()});
            return ModuleVersion.OLDER_VERSION;
        }
        return ModuleVersion.NOT_INSTALLED;
    }

    public void stopContainer(String deployId) {
        InvokeContainer stopContainer = new InvokeContainer(deployId);
        stopContainer.execute("stop");
    }
}

