/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.aws;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import nl.jpoint.vertx.mod.cluster.aws.AwsContext;
import nl.jpoint.vertx.mod.cluster.aws.AwsException;
import nl.jpoint.vertx.mod.cluster.aws.AwsState;
import nl.jpoint.vertx.mod.cluster.aws.AwsUtil;
import nl.jpoint.vertx.mod.cluster.aws.AwsXpathUtil;
import org.apache.http.client.methods.HttpPost;

public class AwsElbUtil {
    private static final String EQUALSSIGN = "=";
    private static final String AWS_ELB_SERVICE = "elasticloadbalancing";
    private static final String AWS_ACTION = "Action";
    private static final String AWS_ACTION_DESCRIBE_LB = "DescribeLoadBalancers";
    private static final String AWS_ACTION_REGISTER_INSTANCE = "RegisterInstancesWithLoadBalancer";
    private static final String AWS_ACTION_DEREGISTER_INSTANCE = "DeregisterInstancesFromLoadBalancer";
    private static final String SERVICE_VERSION = "2012-06-01";
    protected final SimpleDateFormat compressedIso8601DateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private final String region;
    private final String loadbalancer;
    private final AwsUtil awsUtil;
    private final String instanceId;

    public AwsElbUtil(String accessKey, String secretAccessKey, String region, String loadbalancer, String instanceId) {
        this(new AwsUtil(accessKey, secretAccessKey), region, loadbalancer, instanceId);
    }

    public AwsElbUtil(AwsUtil awsUtil, String region, String loadbalancer, String instanceId) {
        this.region = region;
        this.loadbalancer = loadbalancer;
        this.instanceId = instanceId;
        this.awsUtil = awsUtil;
        this.compressedIso8601DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public AwsElbUtil(AwsContext context, String region) {
        this.region = region;
        this.loadbalancer = null;
        this.instanceId = null;
        this.awsUtil = context.getAwsUtil();
        this.compressedIso8601DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public List<String> listLBInstanceMembers() throws AwsException {
        byte[] lbInfo = this.executeDescribeLBRequest();
        return AwsXpathUtil.listInstances(lbInfo);
    }

    public boolean registerInstanceWithLoadbalancer() throws AwsException {
        byte[] result = this.executeRegisterInstanceFromLoadbalancer(AWS_ACTION_REGISTER_INSTANCE);
        List<String> members = AwsXpathUtil.listInstances(result);
        return members.contains(this.instanceId);
    }

    public boolean deRegisterInstanceFromLoadbalancer() throws AwsException {
        byte[] result = this.executeRegisterInstanceFromLoadbalancer(AWS_ACTION_DEREGISTER_INSTANCE);
        List<String> members = AwsXpathUtil.listInstances(result);
        return members.contains(this.instanceId);
    }

    public AwsState getInstanceState() throws AwsException {
        byte[] result = this.executeGetInstanceState();
        return AwsState.valueOf(AwsXpathUtil.instanceState(result, this.forInstanceId()).toUpperCase());
    }

    public AwsState getInstanceState(String instanceId, String loadbalancer) throws AwsException {
        byte[] result = this.executeGetInstanceState(loadbalancer);
        return AwsState.valueOf(AwsXpathUtil.instanceState(result, instanceId).toUpperCase());
    }

    private byte[] executeGetInstanceState() throws AwsException {
        return this.executeGetInstanceState(this.forLoadbalancer());
    }

    private byte[] executeGetInstanceState(String loadbalancer) throws AwsException {
        String targetHost = "elasticloadbalancing." + this.region + ".amazonaws.com";
        String date = this.compressedIso8601DateFormat.format(new Date());
        Map<String, String> signedHeaders = this.createDefaultSignedHeaders(date, targetHost);
        HttpPost awsPost = this.awsUtil.createSignedPost(targetHost, signedHeaders, date, "Action=DescribeInstanceHealth&LoadBalancerName=" + loadbalancer + "&" + "Version" + EQUALSSIGN + SERVICE_VERSION, AWS_ELB_SERVICE, this.region);
        return this.executeRequest(awsPost);
    }

    private byte[] executeRegisterInstanceFromLoadbalancer(String action) throws AwsException {
        String targetHost = "elasticloadbalancing." + this.region + ".amazonaws.com";
        String date = this.compressedIso8601DateFormat.format(new Date());
        StringBuilder payloadBuilder = new StringBuilder(AWS_ACTION).append(EQUALSSIGN).append(action).append("&").append("Instances.member.1.InstanceId").append(EQUALSSIGN).append(this.instanceId).append("&").append("LoadBalancerName").append(EQUALSSIGN).append(this.loadbalancer).append("&").append("Version").append(EQUALSSIGN).append(SERVICE_VERSION);
        Map<String, String> signedHeaders = this.createDefaultSignedHeaders(date, targetHost);
        HttpPost awsPost = this.awsUtil.createSignedPost(targetHost, signedHeaders, date, payloadBuilder.toString(), AWS_ELB_SERVICE, this.region);
        return this.executeRequest(awsPost);
    }

    private byte[] executeDescribeLBRequest() throws AwsException {
        String targetHost = "elasticloadbalancing." + this.region + ".amazonaws.com";
        String date = this.compressedIso8601DateFormat.format(new Date());
        StringBuilder payloadBuilder = new StringBuilder(AWS_ACTION).append(EQUALSSIGN).append(AWS_ACTION_DESCRIBE_LB).append("&").append("LoadBalancerNames.member.1").append(EQUALSSIGN).append(this.loadbalancer).append("&").append("Version").append(EQUALSSIGN).append(SERVICE_VERSION);
        Map<String, String> signedHeaders = this.createDefaultSignedHeaders(date, targetHost);
        HttpPost awsPost = this.awsUtil.createSignedPost(targetHost, signedHeaders, date, payloadBuilder.toString(), AWS_ELB_SERVICE, this.region);
        return this.executeRequest(awsPost);
    }

    /*
     * Exception decompiling
     */
    private byte[] executeRequest(HttpPost awsPost) throws AwsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, String> createDefaultSignedHeaders(String date, String targetHost) {
        HashMap<String, String> signedHeaders = new HashMap<String, String>();
        signedHeaders.put("X-Amz-Date", date);
        signedHeaders.put("Host", targetHost);
        return signedHeaders;
    }

    public String forInstanceId() {
        return this.instanceId;
    }

    public String forLoadbalancer() {
        return this.loadbalancer;
    }

    public String forRegion() {
        return this.region;
    }
}

