/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.aws.state;

import nl.jpoint.vertx.mod.cluster.aws.AwsAutoScalingUtil;
import nl.jpoint.vertx.mod.cluster.aws.AwsContext;
import nl.jpoint.vertx.mod.cluster.aws.AwsState;
import nl.jpoint.vertx.mod.cluster.command.Command;
import nl.jpoint.vertx.mod.cluster.handler.internal.AwsAsRegistrationStatusPollingHandler;
import nl.jpoint.vertx.mod.cluster.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class AwsAsDeRegisterInstance
implements Command<DeployRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AwsAsDeRegisterInstance.class);
    private final Vertx vertx;
    private final AwsAutoScalingUtil awsAsUtil;

    public AwsAsDeRegisterInstance(Vertx vertx, AwsContext context) {
        this.awsAsUtil = new AwsAutoScalingUtil(context);
        this.vertx = vertx;
    }

    @Override
    public JsonObject execute(DeployRequest request) {
        if (!this.awsAsUtil.enterStandby(request.getInstanceId(), request.getAutoScalingGroup())) {
            LOG.info("[{} - {}]: Failed to enter standby for Instance {} in auto scaling group {}.", new Object[]{"ConfigureAwsAutoScaling", request.getId(), request.getInstanceId(), request.getAutoScalingGroup()});
            return new JsonObject().putBoolean("success", Boolean.valueOf(false));
        }
        LOG.info("[{} - {}]: Starting instance status poller for instance id {} in auto scaling group {}", new Object[]{"ConfigureAwsAutoScaling", request.getId(), request.getInstanceId(), request.getAutoScalingGroup()});
        this.vertx.setPeriodic(5000L, (Handler)new AwsAsRegistrationStatusPollingHandler(request, this.awsAsUtil, this.vertx, AwsState.STANDBY));
        return new JsonObject().putBoolean("success", Boolean.valueOf(true));
    }
}

