/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.handler.internal;

import java.util.List;
import nl.jpoint.vertx.mod.cluster.aws.AwsAutoScalingUtil;
import nl.jpoint.vertx.mod.cluster.aws.AwsElbUtil;
import nl.jpoint.vertx.mod.cluster.aws.AwsException;
import nl.jpoint.vertx.mod.cluster.aws.AwsState;
import nl.jpoint.vertx.mod.cluster.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class AwsAsRegistrationStatusPollingHandler
implements Handler<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(AwsAsRegistrationStatusPollingHandler.class);
    private final DeployRequest request;
    private final AwsAutoScalingUtil asUtil;
    private final AwsElbUtil elbUtil;
    private final Vertx vertx;
    private final AwsState state;
    private List<String> loadbalancers = null;

    public AwsAsRegistrationStatusPollingHandler(DeployRequest request, AwsAutoScalingUtil asUtil, AwsElbUtil elbUtil, Vertx vertx, AwsState state) {
        this.request = request;
        this.asUtil = asUtil;
        this.elbUtil = elbUtil;
        this.vertx = vertx;
        this.state = state;
        LOG.info("[{} - {}]: Waiting for instance {} status in auto scaling group {} to reach {}.", new Object[]{"ConfigureAwsAutoScaling", request.getId(), request.getInstanceId(), request.getAutoScalingGroup(), state});
    }

    public AwsAsRegistrationStatusPollingHandler(DeployRequest request, AwsAutoScalingUtil awsAsUtil, Vertx vertx, AwsState standby) {
        this(request, awsAsUtil, null, vertx, standby);
    }

    public void handle(Long timer) {
        try {
            AwsState currentState = this.asUtil.getInstanceState(this.request.getInstanceId(), this.request.getAutoScalingGroup());
            LOG.info("[{} - {}]: Instance {} in auto scaling group {} in state {}", new Object[]{"ConfigureAwsAutoScaling", this.request.getId(), this.request.getInstanceId(), this.request.getAutoScalingGroup(), currentState.name()});
            if (this.state.equals((Object)currentState) && this.checkElbInService()) {
                this.vertx.cancelTimer(timer.longValue());
                this.vertx.eventBus().send("aws.service.deploy", new JsonObject().putBoolean("success", Boolean.valueOf(true)).putString("id", this.request.getId().toString()).putString("state", this.state.toString()));
            }
        }
        catch (AwsException e) {
            LOG.error("[{} - {}]: Error executing de-register", new Object[]{"ConfigureAwsAutoScaling", this.request.getId(), e.getMessage()});
        }
    }

    private boolean checkElbInService() {
        if (AwsState.INSERVICE.equals((Object)this.state) && this.elbUtil != null) {
            if (this.loadbalancers == null) {
                try {
                    this.loadbalancers = this.asUtil.listLoadBalancers(this.request.getAutoScalingGroup());
                }
                catch (AwsException e) {
                    LOG.error("[{} - {}]: Error executing list elb in auto scaling group request", new Object[]{"ConfigureAwsAutoScaling", this.request.getId(), e.getMessage()});
                }
            }
            for (String loadbalancer : this.loadbalancers) {
                try {
                    LOG.info("[{} - {}]: Cheking Instance {} state on elb {}", new Object[]{"ConfigureAwsAutoScaling", this.request.getId(), this.request.getInstanceId(), loadbalancer});
                    AwsState currentElbState = this.elbUtil.getInstanceState(this.request.getInstanceId(), loadbalancer);
                    LOG.info("[{} - {}]: Instance {} on elb {} in state {}", new Object[]{"ConfigureAwsAutoScaling", this.request.getId(), this.request.getInstanceId(), loadbalancer, currentElbState.name()});
                    if (AwsState.INSERVICE.equals((Object)currentElbState)) continue;
                    return false;
                }
                catch (AwsException e) {
                    LOG.error("[{} - {}]: Error executing list elb state for instance {} on elb {} with error", new Object[]{"ConfigureAwsAutoScaling", this.request.getId(), this.request.getInstanceId(), loadbalancer, e.getMessage()});
                    return false;
                }
            }
            LOG.info("[{} - {}]: Instance {}  in service on all elb's {}.", new Object[]{"ConfigureAwsAutoScaling", this.request.getId(), this.request.getInstanceId()});
            return true;
        }
        return true;
    }
}

