/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.command;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.jpoint.vertx.mod.cluster.command.Command;
import nl.jpoint.vertx.mod.cluster.request.ModuleRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;

public class DownloadArtifact
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadArtifact.class);
    private static final String CONF_REPOS_TXT = "/conf/repos.txt";
    private final JsonObject config;
    private List<String> remoteRepositories;

    public DownloadArtifact(JsonObject config) {
        this.config = config;
        this.initializeRepoList();
    }

    private void initializeRepoList() {
        String reposFile = this.config.getString("vertx.home") + CONF_REPOS_TXT;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(reposFile))));
            this.remoteRepositories = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("maven:")) continue;
                this.remoteRepositories.add(line.substring(6));
            }
        }
        catch (IOException e) {
            LOG.error("[{}]: Error initializing remote repositories {}.", (Object)"DeploySiteRequest", (Object)e.getMessage());
        }
        if (this.remoteRepositories.size() == 0) {
            LOG.error("[{}]: No remote repositories initialized {}.", (Object)"DeploySiteRequest");
        }
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        boolean secure = true;
        if (this.config.containsField("http.authSecure")) {
            secure = this.config.getBoolean("http.authSecure");
        }
        credsProvider.setCredentials(new AuthScope(this.config.getString("http.authUri"), secure ? 443 : 80), (Credentials)new UsernamePasswordCredentials(this.config.getString("http.authUser"), this.config.getString("http.authPass")));
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        boolean downloaded = false;
        Iterator<String> it = this.remoteRepositories.iterator();
        while (it.hasNext() && !downloaded) {
            String uri = it.next();
            HttpGet get = new HttpGet(uri + "/" + request.getRemoteLocation());
            try {
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);
                Throwable throwable = null;
                try {
                    if (response.getStatusLine().getStatusCode() == HttpResponseStatus.OK.code()) {
                        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(new File(this.config.getString("artifact.repo") + request.getModuleId() + ".zip")));
                        response.getEntity().writeTo((OutputStream)fos);
                        response.close();
                        ((OutputStream)fos).close();
                        LOG.info("[{} - {}]: Downloaded artifact {} to {}.", new Object[]{"DeploySiteRequest", request.getId(), request.getModuleId(), this.config.getString("artifact.repo") + request.getModuleId() + ".zip"});
                        downloaded = true;
                        continue;
                    }
                    LOG.error("[{} - {}]: Error downloading artifact {}.", new Object[]{"DeploySiteRequest", request.getId(), request.getModuleId()});
                    LOG.error("[{} - {}]: HttpClient Error [{}] -> {}.", new Object[]{"DeploySiteRequest", request.getId(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (IOException e) {
                LOG.error("[{} - {}]: IOException while Error downloading artifact {}. Reason '{}'", new Object[]{"DeploySiteRequest", request.getId(), request.getArtifactId(), e.getMessage()});
            }
        }
        return new JsonObject().putBoolean("success", Boolean.valueOf(downloaded));
    }
}

