/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import nl.jpoint.vertx.mod.cluster.command.Command;
import nl.jpoint.vertx.mod.cluster.request.DeployModuleRequest;
import nl.jpoint.vertx.mod.cluster.request.ModuleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;

public class RunModule
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(RunModule.class);

    @Override
    public JsonObject execute(ModuleRequest request) {
        LOG.info("[{} - {}]: Running module {}.", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId()});
        boolean success = false;
        try {
            String outputLine;
            Process runProcess = Runtime.getRuntime().exec(new String[]{"/etc/init.d/vertx", "start-module", request.getModuleId(), String.valueOf(((DeployModuleRequest)request).getInstances())});
            runProcess.waitFor();
            int exitValue = runProcess.exitValue();
            if (exitValue == 0) {
                success = true;
            }
            BufferedReader output = new BufferedReader(new InputStreamReader(runProcess.getInputStream()));
            while ((outputLine = output.readLine()) != null) {
                LOG.info("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), outputLine});
            }
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(runProcess.getErrorStream()));
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), errorLine});
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to initialize module {}", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        }
        return new JsonObject().putString("deploy_id", request.getId().toString()).putBoolean("success", Boolean.valueOf(success));
    }
}

