/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.service;

import nl.jpoint.vertx.mod.cluster.command.DownloadArtifact;
import nl.jpoint.vertx.mod.cluster.command.ExtractArtifact;
import nl.jpoint.vertx.mod.cluster.command.ResolveSnapshotVersion;
import nl.jpoint.vertx.mod.cluster.request.ModuleRequest;
import nl.jpoint.vertx.mod.cluster.service.DeployService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.shareddata.ConcurrentSharedMap;

public class DeployArtifactService
implements DeployService {
    private static final Logger LOG = LoggerFactory.getLogger(DeployArtifactService.class);
    private final Vertx vertx;
    private final JsonObject config;
    private final ConcurrentSharedMap<String, String> installedArtifacts;

    public DeployArtifactService(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
        this.installedArtifacts = vertx.sharedData().getMap("installedArtifacts");
    }

    @Override
    public boolean deploy(ModuleRequest deployRequest) {
        ResolveSnapshotVersion resolveVersion;
        JsonObject result;
        if (deployRequest.isSnapshot() && (result = (resolveVersion = new ResolveSnapshotVersion(this.config, "DeploySiteRequest")).execute(deployRequest)).getBoolean("success").booleanValue()) {
            deployRequest.setSnapshotVersion(result.getString("version"));
        }
        if (this.installedArtifacts.containsKey((Object)(deployRequest.getGroupId() + ":" + deployRequest.getArtifactId())) && ((String)this.installedArtifacts.get((Object)(deployRequest.getGroupId() + ":" + deployRequest.getArtifactId()))).equals(deployRequest.getSnapshotVersion())) {
            LOG.info("[{} - {}]: Same SNAPSHOT version ({}) of Artifact {} already installed.", new Object[]{"DeploySiteRequest", deployRequest.getId(), deployRequest.getSnapshotVersion(), deployRequest.getModuleId()});
            return true;
        }
        DownloadArtifact command = new DownloadArtifact(this.config);
        JsonObject downloadResult = command.execute(deployRequest);
        if (!downloadResult.getBoolean("success").booleanValue()) {
            return false;
        }
        ExtractArtifact extractSite = new ExtractArtifact(this.vertx, this.config);
        JsonObject extractResult = extractSite.execute(deployRequest);
        if (deployRequest.getSnapshotVersion() != null) {
            this.installedArtifacts.put((Object)(deployRequest.getGroupId() + ":" + deployRequest.getArtifactId()), (Object)deployRequest.getSnapshotVersion());
        }
        return extractResult.getBoolean("success");
    }
}

