/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import nl.jpoint.vertx.mod.cluster.request.DeployModuleRequest;
import nl.jpoint.vertx.mod.cluster.service.DeployService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

public class RestDeployModuleHandler
implements Handler<HttpServerRequest> {
    private final DeployService service;
    private final Logger LOG = LoggerFactory.getLogger(RestDeployModuleHandler.class);

    public RestDeployModuleHandler(DeployService service) {
        MDC.put((String)"service", (String)"deploy");
        this.service = service;
    }

    public void handle(final HttpServerRequest request) {
        request.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                DeployModuleRequest deployRequest;
                byte[] postData = event.getBytes();
                if (postData == null || postData.length == 0) {
                    RestDeployModuleHandler.this.LOG.error("{}: No postdata in request.", (Object)"DeployRequest");
                    request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code());
                    request.response().end();
                    return;
                }
                try {
                    deployRequest = (DeployModuleRequest)new ObjectMapper().reader(DeployModuleRequest.class).readValue(postData);
                }
                catch (IOException e) {
                    RestDeployModuleHandler.this.LOG.error("[{}]: Failed to read postdata {}", (Object)new String(postData));
                    RestDeployModuleHandler.this.respondFailed(request);
                    return;
                }
                RestDeployModuleHandler.this.LOG.info("[{} - {}]: Received deploy module {}", new Object[]{"DeployRequest", deployRequest.getId().toString(), deployRequest.toString()});
                boolean result = RestDeployModuleHandler.this.service.deploy(deployRequest);
                if (!result) {
                    RestDeployModuleHandler.this.respondFailed(request);
                    return;
                }
                RestDeployModuleHandler.this.respondOk(request);
            }
        });
    }

    private void respondOk(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        request.response().end();
    }

    private void respondFailed(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        request.response().end();
    }
}

