/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.UUID;
import nl.jpoint.vertx.mod.cluster.request.DeployArtifactRequest;
import nl.jpoint.vertx.mod.cluster.request.DeployConfigRequest;
import nl.jpoint.vertx.mod.cluster.request.DeployModuleRequest;
import nl.jpoint.vertx.mod.cluster.request.DeployState;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeployRequest {
    private final UUID id = UUID.randomUUID();
    private final List<DeployModuleRequest> modules;
    private final List<DeployConfigRequest> configs;
    private final List<DeployArtifactRequest> artifacts;
    private final boolean elb;
    private final boolean autoScaling;
    private final String autoScalingGroup;
    private final String instanceId;
    private final boolean restart;
    private DeployState state;

    @JsonCreator
    public DeployRequest(@JsonProperty(value="modules") List<DeployModuleRequest> modules, @JsonProperty(value="artifacts") List<DeployArtifactRequest> artifacts, @JsonProperty(value="configs") List<DeployConfigRequest> configs, @JsonProperty(value="with_elb") boolean elb, @JsonProperty(value="with_as") boolean autoScaling, @JsonProperty(value="as_group_id") String autoScalingGroup, @JsonProperty(value="instance_id") String instanceId, @JsonProperty(value="restart") boolean restart) {
        this.modules = modules;
        this.artifacts = artifacts;
        this.configs = configs;
        this.elb = elb;
        this.autoScaling = autoScaling;
        this.autoScalingGroup = autoScalingGroup;
        this.instanceId = instanceId;
        this.restart = restart;
    }

    public List<DeployArtifactRequest> getArtifacts() {
        return this.artifacts;
    }

    public List<DeployModuleRequest> getModules() {
        return this.modules;
    }

    public List<DeployConfigRequest> getConfigs() {
        return this.configs;
    }

    public UUID getId() {
        return this.id;
    }

    public String getAutoScalingGroup() {
        return this.autoScalingGroup;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean withElb() {
        return this.elb;
    }

    public boolean withAutoScaling() {
        return this.elb && this.autoScaling;
    }

    public boolean withRestart() {
        return this.restart;
    }

    public void setState(DeployState state) {
        this.state = state;
    }

    public DeployState getState() {
        return this.state;
    }
}

