/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import nl.jpoint.vertx.mod.cluster.request.DeployArtifactRequest;
import nl.jpoint.vertx.mod.cluster.service.DeployService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

public class RestDeployArtifactHandler
implements Handler<HttpServerRequest> {
    private final DeployService service;
    private final Logger LOG = LoggerFactory.getLogger(RestDeployArtifactHandler.class);

    public RestDeployArtifactHandler(DeployService service) {
        MDC.put((String)"service", (String)"deploy");
        this.service = service;
    }

    public void handle(final HttpServerRequest request) {
        request.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                DeployArtifactRequest artifactRequest;
                byte[] postData = event.getBytes();
                if (postData == null || postData.length == 0) {
                    RestDeployArtifactHandler.this.LOG.error("{}: No postdata in request.", (Object)"DeploySiteRequest");
                    request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code());
                    request.response().end();
                    return;
                }
                try {
                    artifactRequest = (DeployArtifactRequest)new ObjectMapper().reader(DeployArtifactRequest.class).readValue(postData);
                }
                catch (IOException e) {
                    RestDeployArtifactHandler.this.LOG.error("[{}]: Failed to read postdata {}", (Object)new String(postData));
                    RestDeployArtifactHandler.this.respondFailed(request);
                    return;
                }
                RestDeployArtifactHandler.this.LOG.info("[{} - {}]: Received deploy artifact request {}", new Object[]{"DeploySiteRequest", artifactRequest.getId().toString(), new String(postData)});
                boolean result = RestDeployArtifactHandler.this.service.deploy(artifactRequest);
                if (!result) {
                    RestDeployArtifactHandler.this.respondFailed(request);
                    return;
                }
                RestDeployArtifactHandler.this.respondOk(request);
            }
        });
    }

    private void respondOk(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        request.response().end();
    }

    private void respondFailed(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        request.response().end();
    }
}

