/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.request;

import java.util.UUID;

public abstract class ModuleRequest {
    private final UUID id = UUID.randomUUID();
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private String snapshotVersion = null;

    ModuleRequest(String groupId, String artifactId, String version, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
    }

    ModuleRequest(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public UUID getId() {
        return this.id;
    }

    public String getModuleId() {
        return this.groupId + "~" + this.artifactId + "~" + this.version;
    }

    public String getMavenArtifactId() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String getRemoteLocation() {
        StringBuilder builder = new StringBuilder().append(this.getGroupId().replaceAll("\\.", "/")).append("/").append(this.getArtifactId()).append("/").append(this.getVersion()).append("/").append(this.getArtifactId()).append("-");
        if (this.snapshotVersion != null) {
            builder.append(this.getSnapshotVersion());
        } else {
            builder.append(this.getVersion());
        }
        if (this.classifier != null && !this.classifier.isEmpty()) {
            builder.append("-").append(this.classifier);
        }
        builder.append(".zip");
        return builder.toString();
    }

    public String getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public void setSnapshotVersion(String snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    public boolean isAsync() {
        return false;
    }

    public boolean isSnapshot() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public String getMetadataLocation() {
        return this.getGroupId().replaceAll("\\.", "/") + "/" + this.getArtifactId() + "/" + this.getVersion() + "/" + "maven-metadata.xml";
    }

    public abstract boolean restart();
}

