/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import nl.jpoint.vertx.mod.cluster.command.Command;
import nl.jpoint.vertx.mod.cluster.request.ModuleRequest;
import nl.jpoint.vertx.mod.cluster.util.ModuleFileNameFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class StopModule
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(StopModule.class);
    private final Vertx vertx;
    private final File modRoot;

    public StopModule(Vertx vertx, File modRoot) {
        this.vertx = vertx;
        this.modRoot = modRoot;
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        JsonObject result = new JsonObject();
        result.putBoolean("module_stopped", Boolean.valueOf(false));
        for (String file : this.modRoot.list(new ModuleFileNameFilter(request))) {
            LOG.info("[{} - {}]: Stopping module {}", new Object[]{"DeployRequest", request.getId(), file});
            try {
                String outputLine;
                Process killProcess = Runtime.getRuntime().exec(new String[]{"sudo", "/etc/init.d/vertx", "stop-module", file});
                killProcess.waitFor();
                int exitValue = killProcess.exitValue();
                BufferedReader output = new BufferedReader(new InputStreamReader(killProcess.getInputStream()));
                while ((outputLine = output.readLine()) != null) {
                    LOG.info("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), outputLine});
                }
                if (exitValue != 0) {
                    String errorLine;
                    BufferedReader errorOut = new BufferedReader(new InputStreamReader(killProcess.getErrorStream()));
                    while ((errorLine = errorOut.readLine()) != null) {
                        LOG.error("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), errorLine});
                    }
                }
                result.putBoolean("module_stopped", Boolean.valueOf(true));
            }
            catch (IOException | InterruptedException e) {
                LOG.error("[{} - {}]: Failed to stop module {}", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
                return result;
            }
        }
        return result;
    }
}

