/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.aws;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import nl.jpoint.vertx.mod.cluster.aws.AwsContext;
import nl.jpoint.vertx.mod.cluster.aws.AwsException;
import nl.jpoint.vertx.mod.cluster.aws.AwsState;
import nl.jpoint.vertx.mod.cluster.aws.AwsUtil;
import nl.jpoint.vertx.mod.cluster.aws.AwsXpathUtil;
import org.apache.http.client.methods.HttpGet;

public class AwsAutoScalingUtil {
    private static final String AWS_AUTOSCALING_SERVICE = "autoscaling";
    private static final String DEFAULT_REGION = "eu-west-1";
    private final String targetHost = "autoscaling.eu-west-1.amazonaws.com";
    private final AwsUtil awsUtil;
    private final SimpleDateFormat compressedIso8601DateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    @Deprecated
    public AwsAutoScalingUtil(String accessKey, String secretAccessKey) {
        this(AwsContext.build(accessKey, secretAccessKey, DEFAULT_REGION));
    }

    public AwsAutoScalingUtil(AwsContext context) {
        this.awsUtil = context.getAwsUtil();
        this.compressedIso8601DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public List<String> listInstancesInGroup(String groupId) throws AwsException {
        return AwsXpathUtil.listInstancesInAutoscalingGroupResponse(this.describeAutoScalingGroup(groupId));
    }

    public AwsState getInstanceState(String instanceId, String groupId) throws AwsException {
        return AwsXpathUtil.getInstanceState(instanceId, this.describeAutoScalingGroup(groupId));
    }

    public List<String> listLoadBalancers(String groupId) throws AwsException {
        return AwsXpathUtil.listLoadBalancersInGroup(this.describeAutoScalingGroup(groupId));
    }

    public boolean enterStandby(String instanceId, String groupId, boolean decrementDesiredCapacity) {
        String date = this.compressedIso8601DateFormat.format(new Date());
        Map<String, String> signedHeaders = this.createDefaultSignedHeaders(date, "autoscaling.eu-west-1.amazonaws.com");
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("AutoScalingGroupName", groupId);
        requestParameters.put("InstanceIds.member.1", instanceId);
        requestParameters.put("Version", "2011-01-01");
        requestParameters.put("ShouldDecrementDesiredCapacity", Boolean.toString(decrementDesiredCapacity));
        requestParameters.put("Action", "EnterStandby");
        try {
            HttpGet awsGet = this.awsUtil.createSignedGet("autoscaling.eu-west-1.amazonaws.com", requestParameters, signedHeaders, date, AWS_AUTOSCALING_SERVICE, DEFAULT_REGION, "EnterStandby");
            this.executeRequest(awsGet);
        }
        catch (AwsException e) {
            return false;
        }
        return true;
    }

    public boolean exitStandby(String instanceId, String groupId) {
        String date = this.compressedIso8601DateFormat.format(new Date());
        Map<String, String> signedHeaders = this.createDefaultSignedHeaders(date, "autoscaling.eu-west-1.amazonaws.com");
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("AutoScalingGroupName", groupId);
        requestParameters.put("InstanceIds.member.1", instanceId);
        requestParameters.put("Version", "2011-01-01");
        requestParameters.put("Action", "ExitStandby");
        try {
            HttpGet awsGet = this.awsUtil.createSignedGet("autoscaling.eu-west-1.amazonaws.com", requestParameters, signedHeaders, date, AWS_AUTOSCALING_SERVICE, DEFAULT_REGION, "ExitStandby");
            this.executeRequest(awsGet);
        }
        catch (AwsException e) {
            return false;
        }
        return true;
    }

    private byte[] describeAutoScalingGroup(String groupId) throws AwsException {
        String date = this.compressedIso8601DateFormat.format(new Date());
        Map<String, String> signedHeaders = this.createDefaultSignedHeaders(date, "autoscaling.eu-west-1.amazonaws.com");
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("AutoScalingGroupNames.member.1", groupId);
        requestParameters.put("MaxRecords", "20");
        requestParameters.put("Version", "2011-01-01");
        requestParameters.put("Action", "DescribeAutoScalingGroups");
        HttpGet awsGet = this.awsUtil.createSignedGet("autoscaling.eu-west-1.amazonaws.com", requestParameters, signedHeaders, date, AWS_AUTOSCALING_SERVICE, DEFAULT_REGION, "DescribeAutoScalingGroups");
        return this.executeRequest(awsGet);
    }

    /*
     * Exception decompiling
     */
    private byte[] executeRequest(HttpGet awsGet) throws AwsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, String> createDefaultSignedHeaders(String date, String targetHost) {
        HashMap<String, String> signedHeaders = new HashMap<String, String>();
        signedHeaders.put("X-Amz-Date", date);
        signedHeaders.put("Host", targetHost);
        return signedHeaders;
    }
}

