/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import nl.jpoint.vertx.mod.cluster.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;

public class InvokeContainer
implements Command<String> {
    private static final Logger LOG = LoggerFactory.getLogger(InvokeContainer.class);
    private final String deployId;

    public InvokeContainer(String deployId) {
        this.deployId = deployId;
    }

    @Override
    public JsonObject execute(String command) {
        JsonObject result = new JsonObject();
        result.putBoolean("module_stopped", Boolean.valueOf(false));
        LOG.info("[{} - {}]: Invoking container {}", new Object[]{"InvokeContainer", this.deployId, command});
        try {
            String outputLine;
            Process killProcess = Runtime.getRuntime().exec(new String[]{"sudo", "/etc/init.d/vertx", command});
            killProcess.waitFor();
            int exitValue = killProcess.exitValue();
            BufferedReader output = new BufferedReader(new InputStreamReader(killProcess.getInputStream()));
            while ((outputLine = output.readLine()) != null) {
                LOG.info("[{} - {}]: {}", new Object[]{"InvokeContainer", this.deployId, outputLine});
            }
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(killProcess.getErrorStream()));
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error("[{} - {}]: {}", new Object[]{"InvokeContainer", this.deployId, errorLine});
                }
            }
            result.putBoolean("module_stopped", Boolean.valueOf(true));
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to {} container", new Object[]{"InvokeContainer", this.deployId, command});
            return result;
        }
        return result;
    }
}

