/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.aws.state;

import nl.jpoint.vertx.mod.cluster.aws.AwsContext;
import nl.jpoint.vertx.mod.cluster.aws.AwsElbUtil;
import nl.jpoint.vertx.mod.cluster.aws.state.AwsAsRegisterInstance;
import nl.jpoint.vertx.mod.cluster.aws.state.AwsElbRegisterInstance;
import nl.jpoint.vertx.mod.cluster.command.Command;
import nl.jpoint.vertx.mod.cluster.request.DeployRequest;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class AwsRegisterFactory {
    public static Command<DeployRequest> getInstance(AwsContext context, DeployRequest deployRequest, JsonObject config, Vertx vertx) {
        if (deployRequest.withElb() && !deployRequest.withAutoScaling()) {
            AwsElbUtil awsElbUtil = new AwsElbUtil(context.getAwsUtil(), context.getRegion(), config.getString("aws.elb.loadbalancer"), config.getString("aws.elb.instanceid"));
            return new AwsElbRegisterInstance(vertx, awsElbUtil);
        }
        if (deployRequest.withElb() && deployRequest.withAutoScaling()) {
            return new AwsAsRegisterInstance(vertx, context, config.getInteger("aws.as.register.maxduration", 4));
        }
        throw new IllegalStateException("Unable to create registration instance");
    }
}

