/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.command;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import nl.jpoint.vertx.mod.cluster.command.Command;
import nl.jpoint.vertx.mod.cluster.request.DeployModuleRequest;
import nl.jpoint.vertx.mod.cluster.request.ModuleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;

public class RunModule
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(RunModule.class);

    @Override
    public JsonObject execute(ModuleRequest request) {
        LOG.info("[{} - {}]: Running module {}.", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId()});
        boolean success = false;
        try {
            Process runProcess = Runtime.getRuntime().exec(new String[]{"/etc/init.d/vertx", "start-module", request.getModuleId(), String.valueOf(((DeployModuleRequest)request).getInstances())});
            runProcess.waitFor(1L, TimeUnit.MINUTES);
            int exitValue = runProcess.exitValue();
            if (exitValue == 0) {
                success = true;
                LOG.info("[{} - {}]: Started module '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
            }
            if (exitValue != 0) {
                LOG.info("[{} - {}]: {} - Error Starting module '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to initialize module {} with error '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        }
        return new JsonObject().putString("deploy_id", request.getId().toString()).putBoolean("success", Boolean.valueOf(success));
    }
}

