/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import nl.jpoint.vertx.mod.cluster.handler.RestDeployModuleHandler;
import nl.jpoint.vertx.mod.cluster.request.DeployArtifactRequest;
import nl.jpoint.vertx.mod.cluster.request.DeployConfigRequest;
import nl.jpoint.vertx.mod.cluster.request.DeployModuleRequest;
import nl.jpoint.vertx.mod.cluster.request.DeployRequest;
import nl.jpoint.vertx.mod.cluster.service.AwsService;
import nl.jpoint.vertx.mod.cluster.service.DeployModuleService;
import nl.jpoint.vertx.mod.cluster.service.DeployService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

public class RestDeployHandler
implements Handler<HttpServerRequest> {
    private final DeployService<DeployModuleRequest> moduleDeployService;
    private final DeployService<DeployArtifactRequest> artifactDeployService;
    private final DeployService<DeployConfigRequest> configDeployService;
    private final AwsService awsService;
    private final Logger LOG = LoggerFactory.getLogger(RestDeployModuleHandler.class);

    public RestDeployHandler(DeployService<DeployModuleRequest> moduleDeployService, DeployService<DeployArtifactRequest> artifactDeployService, DeployService<DeployConfigRequest> configDeployService, AwsService awsService) {
        MDC.put((String)"service", (String)"deploy");
        this.moduleDeployService = moduleDeployService;
        this.artifactDeployService = artifactDeployService;
        this.configDeployService = configDeployService;
        this.awsService = awsService;
    }

    public void handle(final HttpServerRequest request) {
        request.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                DeployRequest deployRequest;
                ObjectReader reader = new ObjectMapper().reader(DeployRequest.class);
                if (event.getBytes() == null || event.getBytes().length == 0) {
                    RestDeployHandler.this.LOG.error("{}: No postdata in request.", (Object)"DeployRequest");
                    RestDeployHandler.this.respondFailed(request);
                    return;
                }
                byte[] eventBody = event.getBytes();
                RestDeployHandler.this.LOG.debug("{}: received postdata size  -> {} ", (Object)"DeployRequest", (Object)eventBody.length);
                RestDeployHandler.this.LOG.debug("{}: received postdata -> {} ", (Object)"DeployRequest", (Object)new String(eventBody));
                try {
                    deployRequest = (DeployRequest)reader.readValue(event.getBytes());
                }
                catch (IOException e) {
                    RestDeployHandler.this.LOG.error("{}: Error while reading postdata -> {}.", (Object)"DeployRequest", (Object)e.getMessage());
                    RestDeployHandler.this.respondFailed(request);
                    return;
                }
                RestDeployHandler.this.LOG.info("[{} - {}]: Received deploy request with {} config(s), {} module(s) and {} artifact(s) ", new Object[]{"DeployRequest", deployRequest.getId().toString(), deployRequest.getConfigs() != null ? deployRequest.getConfigs().size() : 0, deployRequest.getModules() != null ? deployRequest.getModules().size() : 0, deployRequest.getArtifacts() != null ? deployRequest.getArtifacts().size() : 0});
                boolean deployOk = false;
                if (deployRequest.withElb()) {
                    if (RestDeployHandler.this.awsService.registerRequest(deployRequest)) {
                        RestDeployHandler.this.respondContinue(request, deployRequest.getId().toString());
                        RestDeployHandler.this.awsService.deRegisterInstance(deployRequest.getId().toString());
                    } else {
                        RestDeployHandler.this.respondFailed(request);
                    }
                    return;
                }
                if (deployRequest.withRestart()) {
                    ((DeployModuleService)RestDeployHandler.this.moduleDeployService).stopContainer(deployRequest.getId().toString());
                }
                if (deployRequest.getConfigs() != null && !deployRequest.getConfigs().isEmpty()) {
                    for (DeployConfigRequest configRequest : deployRequest.getConfigs()) {
                        deployOk = RestDeployHandler.this.configDeployService.deploy(configRequest);
                        if (deployOk) continue;
                        RestDeployHandler.this.respondFailed(request);
                        return;
                    }
                }
                if (deployRequest.getArtifacts() != null && !deployRequest.getArtifacts().isEmpty()) {
                    for (DeployArtifactRequest artifactRequest : deployRequest.getArtifacts()) {
                        deployOk = RestDeployHandler.this.artifactDeployService.deploy(artifactRequest);
                        if (deployOk) continue;
                        RestDeployHandler.this.respondFailed(request);
                        return;
                    }
                }
                if (deployRequest.getModules() != null && !deployRequest.getModules().isEmpty()) {
                    for (DeployModuleRequest moduleRequest : deployRequest.getModules()) {
                        deployOk = RestDeployHandler.this.moduleDeployService.deploy(moduleRequest);
                        if (deployOk) continue;
                        RestDeployHandler.this.respondFailed(request);
                        return;
                    }
                }
                RestDeployHandler.this.respondOk(request);
            }
        });
    }

    private void respondOk(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        request.response().end();
    }

    private void respondContinue(HttpServerRequest request, String id) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        request.response().setStatusMessage(id);
        request.response().end(id);
    }

    private void respondFailed(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        request.response().end();
    }
}

