/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.command;

import java.io.File;
import nl.jpoint.vertx.mod.cluster.command.Command;
import nl.jpoint.vertx.mod.cluster.request.ModuleRequest;
import nl.jpoint.vertx.mod.cluster.util.ModuleFileNameFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class UndeployModule
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(UndeployModule.class);
    private final Vertx vertx;
    private final File modRoot;

    public UndeployModule(Vertx vertx, File modRoot) {
        this.vertx = vertx;
        this.modRoot = modRoot;
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        JsonObject result = new JsonObject();
        for (String file : this.modRoot.list(new ModuleFileNameFilter(request))) {
            LOG.info("[{} - {}]: Undeploying module {}", new Object[]{"DeployRequest", request.getId(), file});
            this.vertx.fileSystem().deleteSync(this.modRoot + "/" + file, true);
            LOG.info("[{} - {}]: Undeployed  module : {}", new Object[]{"DeployRequest", request.getId(), file});
        }
        return result;
    }
}

