/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.util.HttpClientWrappingInputStream;
import com.amazonaws.util.SdkHttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpUtils {
    @Deprecated
    public static String urlEncode(String value, boolean path) {
        return SdkHttpUtils.urlEncode(value, path);
    }

    @Deprecated
    public static boolean isUsingNonDefaultPort(URI uri) {
        return SdkHttpUtils.isUsingNonDefaultPort(uri);
    }

    @Deprecated
    public static boolean usePayloadForQueryParameters(Request<?> request) {
        return SdkHttpUtils.usePayloadForQueryParameters(request);
    }

    @Deprecated
    public static String encodeParameters(Request<?> request) {
        return SdkHttpUtils.encodeParameters(request);
    }

    @Deprecated
    public static String appendUri(String baseUri, String path) {
        return SdkHttpUtils.appendUri(baseUri, path);
    }

    @Deprecated
    public static String appendUri(String baseUri, String path, boolean escapeDoubleSlash) {
        return SdkHttpUtils.appendUri(baseUri, path, escapeDoubleSlash);
    }

    public static InputStream fetchFile(URI uri, ClientConfiguration config) throws IOException {
        CloseableHttpResponse response;
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent((HttpParams)httpClientParams, (String)HttpUtils.getUserAgent(config));
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClientParams, (int)HttpUtils.getConnectionTimeout(config));
        HttpConnectionParams.setSoTimeout((HttpParams)httpClientParams, (int)HttpUtils.getSocketTimeout(config));
        DefaultHttpClient httpclient = new DefaultHttpClient((HttpParams)httpClientParams);
        if (config != null) {
            String proxyHost = config.getProxyHost();
            int proxyPort = config.getProxyPort();
            if (proxyHost != null && proxyPort > 0) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                    httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(config.getProxyUsername(), config.getProxyPassword(), config.getProxyWorkstation(), config.getProxyDomain()));
                }
            }
        }
        if ((response = httpclient.execute((HttpUriRequest)new HttpGet(uri))).getStatusLine().getStatusCode() != 200) {
            throw new IOException("Error fetching file from " + uri + ": " + response);
        }
        return new HttpClientWrappingInputStream((HttpClient)httpclient, response.getEntity().getContent());
    }

    private static String getUserAgent(ClientConfiguration config) {
        String userAgent = null;
        if (config != null) {
            userAgent = config.getUserAgent();
        }
        if (userAgent == null) {
            userAgent = ClientConfiguration.DEFAULT_USER_AGENT;
        } else if (!ClientConfiguration.DEFAULT_USER_AGENT.equals(userAgent)) {
            userAgent = userAgent + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        return userAgent;
    }

    private static int getConnectionTimeout(ClientConfiguration config) {
        if (config != null) {
            return config.getConnectionTimeout();
        }
        return 50000;
    }

    private static int getSocketTimeout(ClientConfiguration config) {
        if (config != null) {
            return config.getSocketTimeout();
        }
        return 50000;
    }

    public static URI toUri(String endpoint, ClientConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("ClientConfiguration cannot be null");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint cannot be null");
        }
        if (!endpoint.contains("://")) {
            endpoint = config.getProtocol().toString() + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

