/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy;

import io.netty.handler.codec.http.HttpResponseStatus;
import nl.jpoint.vertx.mod.deploy.handler.RestDeployArtifactHandler;
import nl.jpoint.vertx.mod.deploy.handler.RestDeployAwsHandler;
import nl.jpoint.vertx.mod.deploy.handler.RestDeployHandler;
import nl.jpoint.vertx.mod.deploy.handler.RestDeployModuleHandler;
import nl.jpoint.vertx.mod.deploy.handler.servicebus.DeployHandler;
import nl.jpoint.vertx.mod.deploy.service.AwsService;
import nl.jpoint.vertx.mod.deploy.service.DeployArtifactService;
import nl.jpoint.vertx.mod.deploy.service.DeployConfigService;
import nl.jpoint.vertx.mod.deploy.service.DeployModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.platform.Verticle;

public class AwsDeployModule
extends Verticle {
    private static final Logger LOG = LoggerFactory.getLogger(AwsDeployModule.class);
    private boolean initiated = false;

    public void start() {
        MDC.put((String)"service", (String)"deploy");
        if (this.container.config() == null) {
            LOG.error("Unable to read config file");
            throw new IllegalStateException("Unable to read config file");
        }
        DeployModuleService deployModuleService = new DeployModuleService(this.getVertx(), this.container.config());
        DeployArtifactService deployArtifactService = new DeployArtifactService(this.getVertx(), this.container.config());
        DeployConfigService deployConfigService = new DeployConfigService(this.getVertx(), this.container.config());
        AwsService awsService = this.isLocal() ? null : new AwsService(this.getVertx(), this.container.config());
        this.vertx.eventBus().registerLocalHandler("aws.service.deploy", (Handler)new DeployHandler(awsService, deployModuleService, deployArtifactService, deployConfigService));
        HttpServer httpServer = this.getVertx().createHttpServer();
        RouteMatcher matcher = new RouteMatcher();
        matcher.post("/deploy/deploy*", (Handler)new RestDeployHandler(deployModuleService, deployArtifactService, deployConfigService, awsService));
        matcher.post("/deploy/module*", (Handler)new RestDeployModuleHandler(deployModuleService));
        matcher.post("/deploy/artifact*", (Handler)new RestDeployArtifactHandler(deployArtifactService));
        matcher.get("/deploy/status/:id", (Handler)new RestDeployAwsHandler(awsService));
        matcher.get("/status", event -> {
            if (this.initiated) {
                event.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code());
            } else {
                event.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
            event.response().end();
            event.response().close();
        });
        matcher.noMatch(event -> {
            LOG.error("{}: No match for request {}", (Object)"ClusterManager", (Object)event.absoluteURI());
            event.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code());
            event.response().end();
            event.response().close();
        });
        httpServer.requestHandler((Handler)matcher);
        httpServer.listen(this.getContainer().config().getInteger("http.port", 6789).intValue());
        this.initiated = true;
        LOG.info("{}: Instantiated module.", (Object)"ClusterManager");
    }

    public boolean isLocal() {
        return this.getContainer().config().getBoolean("deploy.internal", false);
    }
}

