/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws.state;

import java.util.List;
import nl.jpoint.vertx.mod.deploy.aws.AwsElbUtil;
import nl.jpoint.vertx.mod.deploy.aws.AwsException;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.handler.internal.AwsElbRegistrationStatusPollingHandler;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class AwsElbDeRegisterInstance
implements Command<DeployRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AwsElbDeRegisterInstance.class);
    private final Vertx vertx;
    private final AwsElbUtil awsElbUtil;

    protected AwsElbDeRegisterInstance(Vertx vertx, AwsElbUtil awsElbUtil) {
        this.vertx = vertx;
        this.awsElbUtil = awsElbUtil;
    }

    @Override
    public JsonObject execute(DeployRequest request) {
        try {
            List<String> instances = this.awsElbUtil.listLBInstanceMembers();
            if (!instances.contains(this.awsElbUtil.forInstanceId())) {
                LOG.info("[{} - {}]: Instance {} not registered with loadbalancer {}.", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.forInstanceId(), this.awsElbUtil.forLoadbalancer()});
                this.vertx.eventBus().send("aws.service.deploy", new JsonObject().putBoolean("success", Boolean.valueOf(true)).putString("id", request.getId().toString()).putString("state", AwsState.NOTREGISTERED.name()));
                return new JsonObject().putBoolean("success", Boolean.valueOf(true));
            }
            if (this.awsElbUtil.deRegisterInstanceFromLoadbalancer()) {
                LOG.info("[{} - {}]: Failed to de-register Instance {} from loadbalancer {}.", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.forInstanceId(), this.awsElbUtil.forLoadbalancer()});
                return new JsonObject().putBoolean("success", Boolean.valueOf(false));
            }
            LOG.info("[{} - {}]: Starting instance status poller for instance id {} on loadbalancer {}", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.forInstanceId(), this.awsElbUtil.forLoadbalancer()});
            this.vertx.setPeriodic(5000L, (Handler)new AwsElbRegistrationStatusPollingHandler(request, this.awsElbUtil, this.vertx, AwsState.OUTOFSERVICE));
        }
        catch (AwsException e) {
            LOG.error("[{} - {}]: Error de-register instance {} from loadbalancer {}.", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.forInstanceId(), this.awsElbUtil.forLoadbalancer()});
            return new JsonObject().putBoolean("success", Boolean.valueOf(false));
        }
        return new JsonObject().putBoolean("success", Boolean.valueOf(true));
    }
}

