/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.PlatformManager;

public class InstallModule
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(InstallModule.class);
    private final PlatformManager platformManager;
    private boolean success = false;
    private AtomicBoolean isDone = new AtomicBoolean(false);
    private final boolean deployInternal;

    public InstallModule(PlatformManager platformManager, JsonObject config) {
        this.platformManager = platformManager;
        this.deployInternal = config.getBoolean("deploy.internal", false);
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        LOG.info("[{} - {}]: Installing module {}.", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId()});
        if (this.deployInternal) {
            this.deployWithManager(request);
        } else {
            this.deployWithInit(request);
        }
        return new JsonObject().putString("deploy_id", request.getId().toString()).putBoolean("success", Boolean.valueOf(this.success));
    }

    private void deployWithManager(ModuleRequest request) {
        this.platformManager.installModule(request.getModuleId(), voidAsyncResult -> {
            this.success = voidAsyncResult.succeeded();
            this.isDone.set(true);
            LOG.info("[{} - {}]: Install Module succeeded {}", new Object[]{"DeployRequest", request.getId(), this.success});
        });
        while (!this.isDone.get()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.error("[{} - {}]: Error while Installing module {}, 'e:{}' ", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId(), e.getMessage()});
                this.success = false;
            }
        }
    }

    private void deployWithInit(ModuleRequest request) {
        try {
            String outputLine;
            Process runProcess = Runtime.getRuntime().exec(new String[]{"/etc/init.d/vertx", "install", request.getModuleId()});
            runProcess.waitFor();
            int exitValue = runProcess.exitValue();
            if (exitValue == 0) {
                this.success = true;
            }
            BufferedReader output = new BufferedReader(new InputStreamReader(runProcess.getInputStream()));
            while ((outputLine = output.readLine()) != null) {
                if (outputLine.contains("Downloading")) continue;
                LOG.info("[{} - {}]: Install Module {}", new Object[]{"DeployRequest", request.getId(), outputLine});
            }
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(runProcess.getErrorStream()));
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error("[{} - {}]: Install module failed {}", new Object[]{"DeployRequest", request.getId(), errorLine});
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to install module {}", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        }
    }
}

