/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.AutoScalingInstanceDetails;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.autoscaling.model.DescribeLoadBalancersResult;
import com.amazonaws.services.autoscaling.model.EnterStandbyRequest;
import com.amazonaws.services.autoscaling.model.ExitStandbyRequest;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.LoadBalancerState;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import nl.jpoint.vertx.mod.deploy.aws.AwsContext;
import nl.jpoint.vertx.mod.deploy.aws.AwsException;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsAutoScalingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AwsAutoScalingUtil.class);
    private static final String IN_SERVICE = "InService";
    private final AmazonAutoScalingClient asClient;

    public AwsAutoScalingUtil(AwsContext context) {
        this.asClient = new AmazonAutoScalingClient(context.getCredentials());
        this.asClient.setRegion(context.getAwsRegion());
    }

    public List<String> listInstancesInGroup(String groupId) throws AwsException {
        try {
            DescribeAutoScalingGroupsResult result = this.asClient.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{groupId}));
            return result.getAutoScalingGroups().stream().flatMap(g -> g.getInstances().stream()).filter(i -> IN_SERVICE.equals(i.getLifecycleState())).map(Instance::getInstanceId).collect(Collectors.toList());
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public AwsState getInstanceState(String instanceId, String groupId) throws AwsException {
        try {
            DescribeAutoScalingInstancesResult result = this.asClient.describeAutoScalingInstances(new DescribeAutoScalingInstancesRequest().withInstanceIds(new String[]{instanceId}));
            Optional<String> state = result.getAutoScalingInstances().stream().filter(i -> i.getInstanceId().equals(instanceId)).map(AutoScalingInstanceDetails::getLifecycleState).findFirst();
            return state.isPresent() ? AwsState.map(state.get()) : AwsState.UNKNOWN;
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public List<String> listLoadBalancers(String groupId) throws AwsException {
        try {
            DescribeLoadBalancersResult result = this.asClient.describeLoadBalancers(new DescribeLoadBalancersRequest().withAutoScalingGroupName(groupId));
            return result.getLoadBalancers().stream().map(LoadBalancerState::getLoadBalancerName).collect(Collectors.toList());
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public boolean enterStandby(String instanceId, String groupId, boolean decrementDesiredCapacity) {
        try {
            this.asClient.enterStandby(new EnterStandbyRequest().withAutoScalingGroupName(groupId).withInstanceIds(new String[]{instanceId}).withShouldDecrementDesiredCapacity(Boolean.valueOf(decrementDesiredCapacity)));
            return true;
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            return false;
        }
    }

    public boolean exitStandby(String instanceId, String groupId) {
        try {
            this.asClient.exitStandby(new ExitStandbyRequest().withAutoScalingGroupName(groupId).withInstanceIds(new String[]{instanceId}));
            return true;
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            return false;
        }
    }
}

