/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.DeployModuleRequest;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.PlatformManager;

public class RunModule
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(RunModule.class);
    private boolean success = false;
    private final boolean deployInternal;
    private final String vertxHome;

    public RunModule(PlatformManager platformManager, JsonObject config) {
        this.deployInternal = config.getBoolean("deploy.internal", false);
        this.vertxHome = config.getString("vertx.home");
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        LOG.info("[{} - {}]: Running module {}.", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId()});
        if (this.deployInternal) {
            this.startFromContainer(request);
        } else {
            this.startWithInit(request);
        }
        return new JsonObject().putString("deploy_id", request.getId().toString()).putBoolean("success", Boolean.valueOf(this.success));
    }

    private void startFromContainer(ModuleRequest request) {
        try {
            System.setProperty("jdk.lang.Process.launchMechanism", "fork");
            Process p = Runtime.getRuntime().exec(new String[]{this.vertxHome + "/bin/vertx", "runmod", request.getModuleId(), "-instances", String.valueOf(((DeployModuleRequest)request).getInstances()), "-conf", this.vertxHome + "/mods/" + request.getModuleId() + "/config.json"}, null, new File(this.vertxHome));
            p.getErrorStream().close();
            p.getOutputStream().close();
            ProcessUtils.writePid(request.getModuleId());
            this.success = true;
        }
        catch (IOException e) {
            LOG.error("[{} - {}]: Failed to initialize module {}", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        }
    }

    public void startWithInit(ModuleRequest request) {
        try {
            Process runProcess = Runtime.getRuntime().exec(new String[]{"/etc/init.d/vertx", "start-module", request.getModuleId(), String.valueOf(((DeployModuleRequest)request).getInstances())});
            runProcess.waitFor(1L, TimeUnit.MINUTES);
            int exitValue = runProcess.exitValue();
            if (exitValue == 0) {
                this.success = true;
                LOG.info("[{} - {}]: Started module '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
            }
            if (exitValue != 0) {
                LOG.info("[{} - {}]: {} - Error Starting module '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to initialize module {} with error '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        }
    }
}

