/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import java.util.HashMap;
import java.util.Map;
import nl.jpoint.vertx.mod.deploy.aws.AwsContext;
import nl.jpoint.vertx.mod.deploy.aws.state.AwsDeRegisterFactory;
import nl.jpoint.vertx.mod.deploy.aws.state.AwsRegisterFactory;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class AwsService {
    private static final Logger LOG = LoggerFactory.getLogger(AwsService.class);
    private static final String DEFAULT_REGION = "eu-west-1";
    private final Vertx vertx;
    private final JsonObject config;
    private AwsContext awsContext;
    private final Map<String, DeployRequest> runningRequests = new HashMap<String, DeployRequest>();

    public AwsService(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
        this.awsContext = AwsContext.build(config.getString("aws.auth.access.key"), config.getString("aws.auth.secret.access.key"), config.getString("aws.region", DEFAULT_REGION));
    }

    public boolean registerRequest(DeployRequest deployRequest) {
        if (this.runningRequests.containsKey(deployRequest.getId().toString())) {
            LOG.error("[{} - {}]: Request already registered.", (Object)"ConfigureAwsElb", (Object)deployRequest.getId());
            return false;
        }
        this.runningRequests.put(deployRequest.getId().toString(), deployRequest);
        return true;
    }

    public boolean deRegisterInstance(String buildId) {
        if (!this.runningRequests.containsKey(buildId)) {
            LOG.error("[{} - {}]: Request not registered.", (Object)"ConfigureAwsElb", (Object)buildId);
            this.failBuild(buildId);
            return false;
        }
        this.runningRequests.get(buildId).setState(DeployState.WAITING_FOR_DEREGISTER);
        Command<DeployRequest> deRegisterCommand = AwsDeRegisterFactory.getInstance(this.awsContext, this.runningRequests.get(buildId), this.config, this.vertx);
        JsonObject deRegisterResult = deRegisterCommand.execute(this.runningRequests.get(buildId));
        if (!deRegisterResult.getBoolean("success").booleanValue()) {
            this.runningRequests.remove(buildId);
            LOG.error("[{} - {}]: de-register failed. removing request.", (Object)"ConfigureAwsElb", (Object)buildId);
        }
        return deRegisterResult.getBoolean("success");
    }

    public boolean registerInstance(String buildId) {
        if (!this.runningRequests.containsKey(buildId)) {
            this.failBuild(buildId);
            LOG.error("[{} - {}]: Request not registered.", (Object)"ConfigureAwsElb", (Object)buildId);
            return false;
        }
        Command<DeployRequest> registerCommand = AwsRegisterFactory.getInstance(this.awsContext, this.runningRequests.get(buildId), this.config, this.vertx);
        registerCommand.execute(this.runningRequests.get(buildId));
        return false;
    }

    public DeployRequest updateAndGetRequest(DeployState state, String buildId) {
        if (this.runningRequests.containsKey(buildId)) {
            LOG.info("[{} - {}]: Updating state to {}", new Object[]{"ConfigureAwsElb", buildId, state});
            this.runningRequests.get(buildId).setState(state);
            return this.runningRequests.get(buildId);
        }
        return null;
    }

    public void failBuild(String buildId) {
        LOG.error("[{} - {}]: Failing build.", (Object)"ConfigureAwsElb", (Object)buildId);
        if (this.runningRequests.containsKey(buildId)) {
            this.runningRequests.get(buildId).setState(DeployState.FAILED);
        }
    }

    public DeployState getDeployStatus(String deployId) {
        if (!this.runningRequests.containsKey(deployId)) {
            return DeployState.UNKNOWN;
        }
        DeployState state = this.runningRequests.get(deployId).getState();
        if (state.equals((Object)DeployState.SUCCESS) || state.equals((Object)DeployState.FAILED)) {
            this.runningRequests.remove(deployId);
        }
        return state;
    }
}

