/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class ExtractArtifact
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractArtifact.class);
    private final Vertx vertx;
    private final JsonObject config;
    private final Path basePath;
    private final boolean deleteBase;
    private final String logConstant;

    public ExtractArtifact(Vertx vertx, JsonObject config, Path basePath, boolean deleteBase, String logConstant) {
        this.vertx = vertx;
        this.config = config;
        this.basePath = basePath;
        this.deleteBase = deleteBase;
        this.logConstant = logConstant;
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        try (FileSystem zipFs = this.getFileSystem(this.config.getString("artifact.repo") + "/" + request.getFileName());){
            LOG.info("[{} - {}]: Extracting artifact {} to {}.", new Object[]{this.logConstant, request.getId(), request.getModuleId(), this.basePath});
            if (this.deleteBase) {
                this.removeBasePath(request, this.basePath);
            }
            Path zipRoot = zipFs.getPath("/", new String[0]);
            Files.walkFileTree(zipRoot, this.CopyingFileVisitor(this.basePath));
            LOG.info("[{} - {}]: Extracted artifact {} to {}.", new Object[]{"DeploySiteRequest", request.getId(), request.getModuleId(), this.basePath});
        }
        catch (IOException | InvalidPathException e) {
            LOG.error("[{} - {}]: Error while extracting artifact {} -> {}.", new Object[]{this.logConstant, request.getId(), request.getModuleId(), e.getMessage()});
            return new JsonObject().putBoolean("success", Boolean.valueOf(false));
        }
        return new JsonObject().putBoolean("success", Boolean.valueOf(true));
    }

    private SimpleFileVisitor<Path> CopyingFileVisitor(final Path basePath) {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if ("artifact_context.xml".equals(file.getFileName().toString())) {
                    return FileVisitResult.CONTINUE;
                }
                Path unpackFile = Paths.get(basePath.toString(), file.toString());
                Files.copy(file, unpackFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path subDir = Paths.get(basePath.toString(), dir.toString());
                if (Files.notExists(subDir, new LinkOption[0])) {
                    Files.createDirectory(subDir, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        };
    }

    private void removeBasePath(ModuleRequest request, Path basePath) {
        if (!basePath.getParent().toFile().exists() || !basePath.getParent().toFile().canWrite()) {
            LOG.warn("[{} - {}]: Unable to extract artifact {} -> {} not exist or not writable.", new Object[]{this.logConstant, request.getId(), request.getModuleId(), basePath.getParent().toString()});
            LOG.warn("[{} - {}]: Unable to extract artifact {} to basePath -> {}.", new Object[]{this.logConstant, request.getId(), request.getModuleId(), basePath.getParent().toFile().toString()});
        }
        if (basePath.toFile().exists()) {
            LOG.info("[{} - {}]: Removing base path -> {}.", new Object[]{this.logConstant, request.getId(), basePath.toAbsolutePath()});
            this.vertx.fileSystem().deleteSync(basePath.toString(), true);
        }
    }

    private FileSystem getFileSystem(String location) throws IOException {
        Path path = Paths.get(location, new String[0]);
        URI uri = URI.create("jar:file:" + path.toUri().getPath());
        return FileSystems.newFileSystem(uri, new HashMap());
    }
}

