/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import java.nio.file.Paths;
import nl.jpoint.vertx.mod.deploy.command.DownloadArtifact;
import nl.jpoint.vertx.mod.deploy.command.ExtractArtifact;
import nl.jpoint.vertx.mod.deploy.command.ResolveSnapshotVersion;
import nl.jpoint.vertx.mod.deploy.command.RunConsoleCommand;
import nl.jpoint.vertx.mod.deploy.request.DeployConfigRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployArtifactService;
import nl.jpoint.vertx.mod.deploy.service.DeployService;
import nl.jpoint.vertx.mod.deploy.util.ArtifactContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class DeployConfigService
implements DeployService<DeployConfigRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DeployArtifactService.class);
    private final Vertx vertx;
    private final JsonObject config;

    public DeployConfigService(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
    }

    @Override
    public boolean deploy(DeployConfigRequest deployRequest) {
        JsonObject restartResult;
        RunConsoleCommand consoleCommand;
        JsonObject testResult;
        DownloadArtifact downloadArtifact;
        JsonObject downloadResult;
        ResolveSnapshotVersion resolveVersion;
        JsonObject result;
        if (deployRequest.isSnapshot() && (result = (resolveVersion = new ResolveSnapshotVersion(this.config, "DeployConfigRequest")).execute(deployRequest)).getBoolean("success").booleanValue()) {
            deployRequest.setSnapshotVersion(result.getString("version"));
        }
        if (!(downloadResult = (downloadArtifact = new DownloadArtifact(this.config)).execute(deployRequest)).getBoolean("success").booleanValue()) {
            return false;
        }
        ArtifactContextUtil artifactContextUtil = new ArtifactContextUtil(this.config.getString("artifact.repo") + "/" + deployRequest.getFileName());
        ExtractArtifact extractConfig = new ExtractArtifact(this.vertx, this.config, Paths.get(artifactContextUtil.getBaseLocation(), new String[0]), false, "DeployConfigRequest");
        JsonObject extractResult = extractConfig.execute(deployRequest);
        if (artifactContextUtil.getTestCommand() != null && !artifactContextUtil.getTestCommand().isEmpty() && !(testResult = (consoleCommand = new RunConsoleCommand(deployRequest.getId().toString())).execute(artifactContextUtil.getTestCommand())).getBoolean("command_status").booleanValue()) {
            LOG.info("ERROR");
            return false;
        }
        if (artifactContextUtil.getRestartCommand() != null && !artifactContextUtil.getRestartCommand().isEmpty() && !(restartResult = (consoleCommand = new RunConsoleCommand(deployRequest.getId().toString())).execute(artifactContextUtil.getRestartCommand())).getBoolean("command_status").booleanValue()) {
            return false;
        }
        return extractResult.getBoolean("success");
    }
}

