/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessUtils.class);

    public static List<Integer> findPidsForModule(String moduleId, String logAction, String requestId) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            Process pgrep = Runtime.getRuntime().exec(new String[]{"pgrep", "-f", moduleId});
            pgrep.waitFor();
            int exitValue = pgrep.exitValue();
            if (exitValue == 0) {
                String outputLine;
                BufferedReader output = new BufferedReader(new InputStreamReader(pgrep.getInputStream()));
                while ((outputLine = output.readLine()) != null) {
                    String[] spids;
                    for (String pid : spids = outputLine.split(" ")) {
                        try {
                            result.add(Integer.parseInt(pid));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("[{} - {}]: Failed to parse pid '{}' for module {}", new Object[]{logAction, requestId, pid, moduleId});
                        }
                    }
                }
            }
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(pgrep.getErrorStream()));
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error("[{} - {}]: Listing pids for module {} failed", new Object[]{logAction, requestId, errorLine});
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]:Listing pids for module {} failed with io exception {}", new Object[]{logAction, requestId, moduleId, e.getMessage()});
        }
        return result;
    }

    public static void stopProcesses(List<Integer> pids, String moduleId, String logAction, UUID id) {
        for (Integer pid : pids) {
            try {
                Process pgrep = Runtime.getRuntime().exec(new String[]{"kill", "-s", "SIGTERM", pid.toString()});
                pgrep.waitFor();
                int exitValue = pgrep.exitValue();
                if (exitValue == 0) {
                    String outputLine;
                    BufferedReader output = new BufferedReader(new InputStreamReader(pgrep.getInputStream()));
                    while ((outputLine = output.readLine()) != null) {
                        LOG.info("[{} - {}]: Module {} with pid '{}' stopped : {} ", new Object[]{logAction, id, moduleId, pid, outputLine});
                    }
                }
                if (exitValue != 0) {
                    String errorLine;
                    BufferedReader errorOut = new BufferedReader(new InputStreamReader(pgrep.getErrorStream()));
                    while ((errorLine = errorOut.readLine()) != null) {
                        LOG.error("[{} - {}]: Error while stopping module {} with pid {} : ", new Object[]{logAction, id, errorLine});
                    }
                }
                ProcessUtils.removePidFile(new File(moduleId));
            }
            catch (IOException | InterruptedException e) {
                LOG.error("[{} - {}]: Stopping module {} with pid {} failed with io exception {}", new Object[]{logAction, id, moduleId, pid, e.getMessage()});
            }
        }
    }

    private static void removePidFile(File pidFile) {
        if (pidFile.exists() && pidFile.isFile()) {
            pidFile.delete();
        }
    }

    private static void executeCommand(String[] command, String logAction, UUID requestId) {
    }

    public static void writePid(String moduleId) {
        List<Integer> pids = ProcessUtils.findPidsForModule(moduleId, null, null);
        File pidFile = new File(moduleId.substring(0, moduleId.lastIndexOf(126)) + ".pid");
        try {
            if (pidFile.createNewFile()) {
                FileWriter wrt = new FileWriter(pidFile);
                wrt.write(pids.get(0).toString());
                wrt.flush();
                wrt.close();
            }
        }
        catch (IOException e) {
            LOG.warn("Error writing pidFile '{}'", (Object)e.getMessage());
        }
    }
}

