/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.InstanceState;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import nl.jpoint.vertx.mod.deploy.aws.AwsContext;
import nl.jpoint.vertx.mod.deploy.aws.AwsException;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsElbUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AwsElbUtil.class);
    private final String loadBalancer;
    private final String instanceId;
    private final AmazonElasticLoadBalancingClient elbClient;

    public AwsElbUtil(AwsContext context, String loadBalancer, String instanceId) {
        this.loadBalancer = loadBalancer;
        this.instanceId = instanceId;
        this.elbClient = new AmazonElasticLoadBalancingClient(context.getCredentials());
        this.elbClient.setRegion(context.getAwsRegion());
    }

    public AwsElbUtil(AwsContext context) {
        this(context, null, null);
    }

    public List<String> listLBInstanceMembers() throws AwsException {
        if (this.loadBalancer != null) {
            try {
                DescribeLoadBalancersResult result = this.elbClient.describeLoadBalancers(new DescribeLoadBalancersRequest().withLoadBalancerNames(new String[]{this.loadBalancer}));
                return result.getLoadBalancerDescriptions().stream().flatMap(d -> d.getInstances().stream()).map(Instance::getInstanceId).collect(Collectors.toList());
            }
            catch (AmazonClientException e) {
                LOG.error("Error executing request 'listLBInstanceMembers' -> {}", (Throwable)e);
                throw new AwsException(e);
            }
        }
        return Collections.emptyList();
    }

    public boolean registerInstanceWithLoadbalancer() throws AwsException {
        if (this.instanceId != null && this.loadBalancer != null) {
            try {
                this.elbClient.registerInstancesWithLoadBalancer(new RegisterInstancesWithLoadBalancerRequest().withLoadBalancerName(this.loadBalancer).withInstances(new Instance[]{new Instance().withInstanceId(this.instanceId)}));
                return true;
            }
            catch (AmazonClientException e) {
                LOG.error("Error executing request 'registerInstanceWithLoadbalancer' -> {}", (Throwable)e);
                throw new AwsException(e);
            }
        }
        return false;
    }

    public boolean deRegisterInstanceFromLoadbalancer() throws AwsException {
        if (this.instanceId != null && this.loadBalancer != null) {
            try {
                this.elbClient.deregisterInstancesFromLoadBalancer(new DeregisterInstancesFromLoadBalancerRequest().withLoadBalancerName(this.loadBalancer).withInstances(new Instance[]{new Instance().withInstanceId(this.instanceId)}));
                return true;
            }
            catch (AmazonClientException e) {
                LOG.error("Error executing request 'deRegisterInstanceFromLoadbalancer' -> {}", (Throwable)e);
                throw new AwsException(e);
            }
        }
        return false;
    }

    public AwsState getInstanceState() throws AwsException {
        return this.getInstanceState(this.instanceId, this.loadBalancer);
    }

    public AwsState getInstanceState(String instanceId, String loadBalancer) throws AwsException {
        if (instanceId != null && loadBalancer != null) {
            try {
                DescribeInstanceHealthResult result = this.elbClient.describeInstanceHealth(new DescribeInstanceHealthRequest().withLoadBalancerName(loadBalancer).withInstances(new Instance[]{new Instance().withInstanceId(instanceId)}));
                Optional<InstanceState> state = result.getInstanceStates().stream().filter(i -> i.getInstanceId().equals(instanceId)).findFirst();
                if (state.isPresent()) {
                    return AwsState.map(state.get().getState());
                }
            }
            catch (AmazonClientException e) {
                LOG.error("Error executing request 'getInstanceState' -> {}", (Throwable)e);
                throw new AwsException(e);
            }
        }
        return AwsState.UNKNOWN;
    }

    public String forInstanceId() {
        return this.instanceId;
    }

    public String forLoadbalancer() {
        return this.loadBalancer;
    }
}

