/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws.state;

import nl.jpoint.vertx.mod.deploy.aws.AwsAutoScalingUtil;
import nl.jpoint.vertx.mod.deploy.aws.AwsContext;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.handler.internal.AwsAsRegistrationStatusPollingHandler;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class AwsAsDeRegisterInstance
implements Command<DeployRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AwsAsDeRegisterInstance.class);
    private final Vertx vertx;
    private final AwsAutoScalingUtil awsAsUtil;
    private final Integer maxDuration;

    public AwsAsDeRegisterInstance(Vertx vertx, AwsContext context, Integer maxDuration) {
        this.maxDuration = maxDuration;
        this.awsAsUtil = new AwsAutoScalingUtil(context);
        this.vertx = vertx;
    }

    @Override
    public JsonObject execute(DeployRequest request) {
        if (!this.awsAsUtil.enterStandby(request.getInstanceId(), request.getAutoScalingGroup(), request.isDecrementDesiredCapacity())) {
            LOG.info("[{} - {}]: Failed to enter standby for Instance {} in auto scaling group {}.", new Object[]{"ConfigureAwsAutoScaling", request.getId(), request.getInstanceId(), request.getAutoScalingGroup()});
            return new JsonObject().putBoolean("success", Boolean.valueOf(false));
        }
        LOG.info("[{} - {}]: Starting instance status poller for instance id {} in auto scaling group {}", new Object[]{"ConfigureAwsAutoScaling", request.getId(), request.getInstanceId(), request.getAutoScalingGroup()});
        this.vertx.setPeriodic(3000L, (Handler)new AwsAsRegistrationStatusPollingHandler(request, this.awsAsUtil, this.vertx, AwsState.STANDBY, this.maxDuration));
        return new JsonObject().putBoolean("success", Boolean.valueOf(true));
    }
}

