/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.util.MetadataXPathUtil;
import nl.jpoint.vertx.mod.deploy.util.PlatformUtils;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;

public class ResolveSnapshotVersion
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ResolveSnapshotVersion.class);
    private final JsonObject config;
    private final String logId;

    public ResolveSnapshotVersion(JsonObject config, String logId) {
        this.config = config;
        this.logId = logId;
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        List<String> repoList = PlatformUtils.initializeRepoList(this.logId, this.config.getString("vertx.home"));
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        boolean secure = true;
        if (this.config.containsField("http.authSecure")) {
            secure = this.config.getBoolean("http.authSecure");
            LOG.warn("[{} - {}]: Unsecure request to artifact repository.", (Object)this.logId, (Object)request.getId());
        }
        credsProvider.setCredentials(new AuthScope(this.config.getString("http.authUri"), secure ? 443 : 80), (Credentials)new UsernamePasswordCredentials(this.config.getString("http.authUser"), this.config.getString("http.authPass")));
        boolean resolved = false;
        String realSnapshotVersion = request.isSnapshot() ? request.getVersion() : null;
        Iterator<String> it = repoList.iterator();
        try (CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();){
            while (it.hasNext() && !resolved) {
                String uri = it.next();
                if (!request.isSnapshot()) continue;
                LOG.info("[{} - {}]: Artifact is -SNAPSHOT, trying to parse metadata for last version {}.", new Object[]{this.logId, request.getId(), request.getModuleId()});
                realSnapshotVersion = this.retrieveAndParseMetadata(request, httpclient, uri);
                if (realSnapshotVersion == null) continue;
                LOG.info("[{} - {}]: Parsed metadata. Snapshot version is {} ", new Object[]{this.logId, request.getId(), realSnapshotVersion});
                resolved = true;
            }
        }
        catch (IOException e) {
            LOG.error("[{} - {}]: IO Exception while downloading artifact {}. Reason '{}'.", new Object[]{this.logId, request.getId(), request.getArtifactId(), e.getMessage()});
        }
        return new JsonObject().putBoolean("success", Boolean.valueOf(resolved)).putString("version", realSnapshotVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String retrieveAndParseMetadata(ModuleRequest request, CloseableHttpClient httpclient, String repoUri) {
        HttpGet getMetadata = new HttpGet(repoUri + "/" + request.getMetadataLocation());
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)getMetadata);){
            String result;
            if (response.getStatusLine().getStatusCode() != HttpResponseStatus.OK.code()) {
                LOG.error("[{} - {}]: No metadata found for module {} with error code {} with request {}", new Object[]{this.logId, request.getId(), request.getModuleId(), response.getStatusLine().getStatusCode(), getMetadata.getURI()});
                String string2 = null;
                return string2;
            }
            byte[] metadata = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            response.close();
            String string = result = MetadataXPathUtil.getRealSnapshotVersionFromMetadata(metadata, request);
            return string;
        }
        catch (IOException e) {
            LOG.error("[{} - {}]: Error while downloading metadata for module {} : {}", new Object[]{this.logId, request.getId(), request.getModuleId(), e.getMessage()});
            return null;
        }
    }
}

