/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import nl.jpoint.vertx.mod.deploy.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;

public class RunConsoleCommand
implements Command<String> {
    private static final Logger LOG = LoggerFactory.getLogger(RunConsoleCommand.class);
    private final String deployId;

    public RunConsoleCommand(String deployId) {
        this.deployId = deployId;
    }

    @Override
    public JsonObject execute(String command) {
        JsonObject result = new JsonObject();
        result.putBoolean("command_status", Boolean.valueOf(false));
        if (command == null || command.isEmpty()) {
            LOG.error("[{} - {}]: Failed to run empty command.", (Object)"ConsoleCommand", (Object)this.deployId);
            return result;
        }
        LOG.info("[{} - {}]: Running console command '{}'", new Object[]{"ConsoleCommand", this.deployId, command});
        try {
            String outputLine;
            Process consoleCommand = Runtime.getRuntime().exec(command);
            consoleCommand.waitFor();
            int exitValue = consoleCommand.exitValue();
            BufferedReader output = new BufferedReader(new InputStreamReader(consoleCommand.getInputStream()));
            while ((outputLine = output.readLine()) != null) {
                LOG.info("[{} - {}]: {}", new Object[]{"ConsoleCommand", this.deployId, outputLine});
            }
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(consoleCommand.getErrorStream()));
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error("[{} - {}]: {}", new Object[]{"ConsoleCommand", this.deployId, errorLine});
                }
            }
            LOG.info("[{} - {}]: result for  console command '{}' is {}", new Object[]{"ConsoleCommand", this.deployId, command, exitValue});
            result.putBoolean("command_status", Boolean.valueOf(exitValue == 0));
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to run command {} with error {}", new Object[]{"ConsoleCommand", this.deployId, command, e});
            return result;
        }
        return result;
    }
}

