/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.util.ModuleFileNameFilter;
import nl.jpoint.vertx.mod.deploy.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class StopModule
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(StopModule.class);
    private boolean success = false;
    private AtomicBoolean isDone = new AtomicBoolean(false);
    private final boolean deployInternal;
    private final Vertx vertx;
    private final File modRoot;
    private final boolean olderVersion;
    final JsonObject result = new JsonObject();

    public StopModule(Vertx vertx, File modRoot, JsonObject config, boolean olderVersion) {
        this.vertx = vertx;
        this.modRoot = modRoot;
        this.olderVersion = olderVersion;
        this.deployInternal = config.getBoolean("deploy.internal", false);
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        this.result.putBoolean("module_stopped", Boolean.valueOf(false));
        if (this.deployInternal) {
            this.stopWithManager(request);
        } else {
            this.stopWithInit(request);
        }
        return this.result;
    }

    private void stopWithManager(ModuleRequest request) {
        for (String file : this.modRoot.list(new ModuleFileNameFilter(request))) {
            String moduleId = request.getModuleId();
            if (this.olderVersion) {
                moduleId = request.getModuleId().substring(0, request.getModuleId().lastIndexOf(126));
            }
            List<Integer> pids = ProcessUtils.findPidsForModule(moduleId, "DeployRequest", request.getId().toString());
            ProcessUtils.stopProcesses(pids, "DeployRequest", request.getModuleId(), request.getId());
            this.result.putBoolean("module_stopped", Boolean.valueOf(true));
        }
    }

    public void stopWithInit(ModuleRequest request) {
        for (String file : this.modRoot.list(new ModuleFileNameFilter(request))) {
            LOG.info("[{} - {}]: Stopping module '{}'", new Object[]{"DeployRequest", request.getId(), file});
            try {
                String outputLine;
                Process killProcess = Runtime.getRuntime().exec(new String[]{"sudo", "/etc/init.d/vertx", "stop-module", file});
                killProcess.waitFor();
                int exitValue = killProcess.exitValue();
                BufferedReader output = new BufferedReader(new InputStreamReader(killProcess.getInputStream()));
                while ((outputLine = output.readLine()) != null && !outputLine.isEmpty()) {
                    LOG.info("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), outputLine});
                }
                if (exitValue != 0) {
                    String errorLine;
                    BufferedReader errorOut = new BufferedReader(new InputStreamReader(killProcess.getErrorStream()));
                    while ((errorLine = errorOut.readLine()) != null) {
                        LOG.error("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), errorLine});
                    }
                }
                this.result.putBoolean("module_stopped", Boolean.valueOf(true));
            }
            catch (IOException | InterruptedException e) {
                LOG.error("[{} - {}]: Failed to stop module {}", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
            }
        }
    }
}

