/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws.state;

import java.util.List;
import nl.jpoint.vertx.mod.deploy.aws.AwsElbUtil;
import nl.jpoint.vertx.mod.deploy.aws.AwsException;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.handler.internal.AwsElbRegistrationStatusPollingHandler;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class AwsElbRegisterInstance
implements Command<DeployRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AwsElbRegisterInstance.class);
    private final Vertx vertx;
    private final AwsElbUtil awsElbUtil;

    protected AwsElbRegisterInstance(Vertx vertx, AwsElbUtil awsElbUtil) {
        this.vertx = vertx;
        this.awsElbUtil = awsElbUtil;
    }

    @Override
    public JsonObject execute(DeployRequest request) {
        try {
            List<String> instances = this.awsElbUtil.listLBInstanceMembers();
            if (instances.contains(this.awsElbUtil.forInstanceId())) {
                LOG.info("[{} - {}]: InstanceId {} is all ready listed as member of loadbalancer {}", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.forInstanceId(), this.awsElbUtil.forLoadbalancer()});
                return new JsonObject().putBoolean("success", Boolean.valueOf(false));
            }
            this.awsElbUtil.registerInstanceWithLoadbalancer();
            LOG.info("[{} - {}]: Starting instance status poller for instance id {} on loadbalancer {}", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.forInstanceId(), this.awsElbUtil.forLoadbalancer()});
            this.vertx.setPeriodic(3000L, (Handler)new AwsElbRegistrationStatusPollingHandler(request, this.awsElbUtil, this.vertx, AwsState.INSERVICE));
            return new JsonObject().putBoolean("success", Boolean.valueOf(true));
        }
        catch (AwsException e) {
            LOG.error("[{} - {}]: Error while executing request to AWS -> {}", new Object[]{"ConfigureAwsElb", request.getId(), e.getMessage()});
            return new JsonObject().putBoolean("success", Boolean.valueOf(false));
        }
    }
}

