/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import java.nio.file.Paths;
import nl.jpoint.vertx.mod.deploy.command.DownloadArtifact;
import nl.jpoint.vertx.mod.deploy.command.ExtractArtifact;
import nl.jpoint.vertx.mod.deploy.command.ResolveSnapshotVersion;
import nl.jpoint.vertx.mod.deploy.request.DeployArtifactRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployService;
import nl.jpoint.vertx.mod.deploy.util.ArtifactContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.shareddata.ConcurrentSharedMap;

public class DeployArtifactService
implements DeployService<DeployArtifactRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DeployArtifactService.class);
    private final Vertx vertx;
    private final JsonObject config;
    private final ConcurrentSharedMap<String, String> installedArtifacts;

    public DeployArtifactService(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
        this.installedArtifacts = vertx.sharedData().getMap("installedArtifacts");
    }

    @Override
    public JsonObject deploy(DeployArtifactRequest deployRequest) {
        DownloadArtifact downloadArtifactCommand;
        JsonObject downloadResult;
        ResolveSnapshotVersion resolveVersion;
        JsonObject result;
        if (deployRequest.isSnapshot() && (result = (resolveVersion = new ResolveSnapshotVersion(this.config, "DeploySiteRequest")).execute(deployRequest)).getBoolean("success").booleanValue()) {
            deployRequest.setSnapshotVersion(result.getString("version"));
        }
        if (this.installedArtifacts.containsKey((Object)(deployRequest.getGroupId() + ":" + deployRequest.getArtifactId())) && ((String)this.installedArtifacts.get((Object)(deployRequest.getGroupId() + ":" + deployRequest.getArtifactId()))).equals(deployRequest.getSnapshotVersion())) {
            LOG.info("[{} - {}]: Same SNAPSHOT version ({}) of Artifact {} already installed.", new Object[]{"DeploySiteRequest", deployRequest.getId(), deployRequest.getSnapshotVersion(), deployRequest.getModuleId()});
            new JsonObject().putBoolean("result", Boolean.valueOf(true));
        }
        if (!(downloadResult = (downloadArtifactCommand = new DownloadArtifact(this.config)).execute(deployRequest)).getBoolean("success").booleanValue()) {
            new JsonObject().putBoolean("result", Boolean.valueOf(false));
        }
        ArtifactContextUtil artifactContextUtil = new ArtifactContextUtil(this.config.getString("artifact.repo") + "/" + deployRequest.getFileName());
        ExtractArtifact extractSite = new ExtractArtifact(this.vertx, this.config, Paths.get(artifactContextUtil.getBaseLocation(), new String[0]), true, false, "DeploySiteRequest");
        JsonObject extractResult = extractSite.execute(deployRequest);
        if (deployRequest.getSnapshotVersion() != null) {
            this.installedArtifacts.put((Object)(deployRequest.getGroupId() + ":" + deployRequest.getArtifactId()), (Object)deployRequest.getSnapshotVersion());
        }
        return new JsonObject().putBoolean("result", extractResult.getBoolean("success"));
    }
}

