/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeregisterInstancesFromLoadBalancerResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Instance> instances;

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new ListWithAutoConstructFlag();
            this.instances.setAutoConstruct(true);
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
        instancesCopy.addAll(instances);
        this.instances = instancesCopy;
    }

    public DeregisterInstancesFromLoadBalancerResult withInstances(Instance ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<Instance>(instances.length));
        }
        for (Instance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public DeregisterInstancesFromLoadBalancerResult withInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
        } else {
            ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
            instancesCopy.addAll(instances);
            this.instances = instancesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterInstancesFromLoadBalancerResult)) {
            return false;
        }
        DeregisterInstancesFromLoadBalancerResult other = (DeregisterInstancesFromLoadBalancerResult)obj;
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        return other.getInstances() == null || other.getInstances().equals(this.getInstances());
    }

    public DeregisterInstancesFromLoadBalancerResult clone() {
        try {
            return (DeregisterInstancesFromLoadBalancerResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

