/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws.state;

import nl.jpoint.vertx.mod.deploy.aws.AwsContext;
import nl.jpoint.vertx.mod.deploy.aws.AwsElbUtil;
import nl.jpoint.vertx.mod.deploy.aws.state.AwsAsDeRegisterInstance;
import nl.jpoint.vertx.mod.deploy.aws.state.AwsElbDeRegisterInstance;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class AwsDeRegisterFactory {
    public static Command<DeployRequest> getInstance(AwsContext context, DeployRequest deployRequest, JsonObject config, Vertx vertx) {
        if (deployRequest.withElb() && !deployRequest.withAutoScaling()) {
            AwsElbUtil awsElbUtil = new AwsElbUtil(context, config.getString("aws.elb.loadbalancer"), config.getString("aws.elb.instanceid"));
            return new AwsElbDeRegisterInstance(vertx, awsElbUtil);
        }
        if (deployRequest.withElb() || deployRequest.withAutoScaling()) {
            return new AwsAsDeRegisterInstance(vertx, context, config.getInteger("aws.as.deregister.maxduration", 4));
        }
        throw new IllegalStateException("Unable to create de-registration instance");
    }
}

