/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.stream.Stream;
import nl.jpoint.vertx.mod.deploy.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;

public class InvokeContainer
implements Command<String> {
    private static final Logger LOG = LoggerFactory.getLogger(InvokeContainer.class);
    private final String deployId;
    private String vertxHome;
    private String[] args;

    public InvokeContainer(String deployId, JsonObject config) {
        this.deployId = deployId;
        this.vertxHome = config.getString("vertx.home");
    }

    @Override
    public JsonObject execute(String method) {
        JsonObject result = new JsonObject();
        result.putBoolean("module_stopped", Boolean.valueOf(false));
        LOG.info("[{} - {}]: Invoking container {}", new Object[]{"InvokeContainer", this.deployId, method});
        try {
            String outputLine;
            String[] cmd = new String[]{this.vertxHome + "/bin/vertx", method};
            String[] command = (String[])Stream.concat(Arrays.stream(cmd), Arrays.stream(this.args)).toArray(String[]::new);
            Process killProcess = Runtime.getRuntime().exec(command);
            killProcess.waitFor();
            int exitValue = killProcess.exitValue();
            BufferedReader output = new BufferedReader(new InputStreamReader(killProcess.getInputStream()));
            while ((outputLine = output.readLine()) != null) {
                LOG.info("[{} - {}]: {}", new Object[]{"InvokeContainer", this.deployId, outputLine});
            }
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(killProcess.getErrorStream()));
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error("[{} - {}]: {}", new Object[]{"InvokeContainer", this.deployId, errorLine});
                }
            }
            result.putBoolean("module_stopped", Boolean.valueOf(true));
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to {} container", new Object[]{"InvokeContainer", this.deployId, method});
            return result;
        }
        return result;
    }

    public InvokeContainer withArgs(String ... args) {
        this.args = args;
        return this;
    }
}

