/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;

public class RunModule
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(RunModule.class);
    private static final String UUID_PATTERN = "[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}";
    private final String vertxHome;
    private final String mavenRepoUrl;
    private final String mavenUser;
    private final String mavenPassword;
    private final String protocol;
    private final String configFile;
    private boolean success = false;

    public RunModule(JsonObject config) {
        this.vertxHome = config.getString("vertx.home");
        this.mavenRepoUrl = config.getString("http.authUri", null);
        this.mavenUser = config.getString("http.authUser", null);
        this.mavenPassword = config.getString("http.authPass", null);
        this.protocol = config.getBoolean("http.authSecure", false) ? "https://" : "http://";
        this.configFile = config.getString("config.location");
    }

    public String buildRemoteRepo() {
        if (this.mavenRepoUrl != null) {
            StringBuilder builder = new StringBuilder(this.protocol);
            if (this.mavenUser != null) {
                builder.append(this.mavenUser).append(":").append(this.mavenPassword).append("@");
            }
            builder.append(this.mavenRepoUrl);
            return builder.toString();
        }
        return null;
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        LOG.info("[{} - {}]: Running module '{}'", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId()});
        String applicationID = this.startWithInit(request);
        return new JsonObject().putString("deploy_id", request.getId().toString()).putString("maven_id", request.getMavenArtifactId()).putString("maven_version", request.getSnapshotVersion() == null ? request.getVersion() : request.getSnapshotVersion()).putString("application_id", applicationID).putBoolean("success", Boolean.valueOf(this.success));
    }

    public String startWithInit(ModuleRequest request) {
        String applicationId = "";
        try {
            Process runProcess = Runtime.getRuntime().exec(new String[]{this.vertxHome + "/bin/vertx", "start", "maven:" + request.getModuleId(), "-conf=" + this.configFile, "-Dvertx.maven.remoteRepos=" + this.buildRemoteRepo()});
            runProcess.waitFor(1L, TimeUnit.MINUTES);
            int exitValue = runProcess.exitValue();
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(runProcess.getErrorStream()));
                LOG.info("[{} - {}]: {} - Error Starting module '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error(errorLine);
                }
            }
            if (exitValue == 0) {
                String outLine;
                this.success = true;
                BufferedReader out = new BufferedReader(new InputStreamReader(runProcess.getInputStream()));
                while ((outLine = out.readLine()) != null) {
                    if (!outLine.matches(UUID_PATTERN)) continue;
                    applicationId = outLine;
                }
                LOG.info("[{} - {}]: Started module '{}' with applicationID '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId(), applicationId});
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to initialize module {} with error '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        }
        return applicationId;
    }
}

