/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;

public class StopModule
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(StopModule.class);
    final JsonObject result = new JsonObject();
    private final String vertxHome;
    private String applicationId;

    public StopModule(JsonObject config) {
        this.vertxHome = config.getString("vertx.home");
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        this.result.putBoolean("module_stopped", Boolean.valueOf(false));
        this.stopWithInit(request, this.applicationId);
        return this.result;
    }

    public void stopWithInit(ModuleRequest request, String applicationId) {
        LOG.info("[{} - {}]: Stopping module '{}' with applicationId '{}'.", new Object[]{"DeployRequest", request.getId(), request.getModuleId(), applicationId});
        try {
            String outputLine;
            Process killProcess = Runtime.getRuntime().exec(new String[]{this.vertxHome + "/bin/vertx", "stop", applicationId});
            killProcess.waitFor(1L, TimeUnit.MINUTES);
            int exitValue = killProcess.exitValue();
            BufferedReader output = new BufferedReader(new InputStreamReader(killProcess.getInputStream()));
            while ((outputLine = output.readLine()) != null && !outputLine.isEmpty()) {
                LOG.info("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), outputLine});
            }
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(killProcess.getErrorStream()));
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), errorLine});
                }
            }
            this.result.putBoolean("module_stopped", Boolean.valueOf(true));
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to stop module {}", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        }
    }

    public StopModule forApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }
}

