/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import java.io.File;
import java.util.Map;
import nl.jpoint.vertx.mod.deploy.command.InvokeContainer;
import nl.jpoint.vertx.mod.deploy.command.ResolveSnapshotVersion;
import nl.jpoint.vertx.mod.deploy.command.RunModule;
import nl.jpoint.vertx.mod.deploy.command.StopModule;
import nl.jpoint.vertx.mod.deploy.request.DeployModuleRequest;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployService;
import nl.jpoint.vertx.mod.deploy.util.ModuleVersion;
import nl.jpoint.vertx.mod.deploy.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class DeployModuleService
implements DeployService<DeployModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DeployModuleService.class);
    private final Vertx vertx;
    private final JsonObject config;
    private final File modRoot;
    private final Map<String, JsonObject> installedModules;

    public DeployModuleService(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
        this.modRoot = new File(config.getString("mod.root"));
        this.installedModules = new ProcessUtils(config).listInstalledAndRunningModules();
    }

    @Override
    public JsonObject deploy(DeployModuleRequest deployRequest) {
        JsonObject runResult;
        RunModule runModCommand;
        ModuleVersion moduleInstalled;
        ResolveSnapshotVersion resolveVersion;
        JsonObject result;
        if (deployRequest.isSnapshot() && (result = (resolveVersion = new ResolveSnapshotVersion(this.config, "DeployRequest")).execute(deployRequest)).getBoolean("success").booleanValue()) {
            deployRequest.setSnapshotVersion(result.getString("version"));
        }
        if ((moduleInstalled = this.moduleInstalled(deployRequest)).equals((Object)ModuleVersion.ERROR)) {
            return new JsonObject().putBoolean("result", Boolean.valueOf(false));
        }
        if (moduleInstalled.equals((Object)ModuleVersion.INSTALLED)) {
            if (deployRequest.restart()) {
                runModCommand = new RunModule(this.config);
                runModCommand.execute(deployRequest);
            }
            return new JsonObject().putBoolean("result", Boolean.valueOf(true));
        }
        if (!moduleInstalled.equals((Object)ModuleVersion.INSTALLED) && moduleInstalled.equals((Object)ModuleVersion.OLDER_VERSION)) {
            StopModule stopModuleCommand;
            JsonObject result2;
            if (!deployRequest.restart() && !(result2 = (stopModuleCommand = new StopModule(this.config).forApplicationId(this.installedModules.get(deployRequest.getMavenArtifactId()).getString("application_id"))).execute(deployRequest)).getBoolean("module_stopped").booleanValue()) {
                return new JsonObject().putBoolean("result", Boolean.valueOf(false));
            }
            this.installedModules.remove(deployRequest.getMavenArtifactId());
        }
        if (!(runResult = (runModCommand = new RunModule(this.config)).execute(deployRequest)).getBoolean("success").booleanValue()) {
            return new JsonObject().putBoolean("result", Boolean.valueOf(false));
        }
        this.installedModules.put(deployRequest.getMavenArtifactId(), runResult);
        return new JsonObject().putBoolean("result", Boolean.valueOf(true));
    }

    private ModuleVersion moduleInstalled(ModuleRequest deployRequest) {
        if (!this.installedModules.containsKey(deployRequest.getMavenArtifactId())) {
            LOG.info("[{} - {}]: Module ({}) not installed.", new Object[]{"DeployRequest", deployRequest.getId(), deployRequest.getModuleId()});
            return ModuleVersion.NOT_INSTALLED;
        }
        JsonObject installedModule = this.installedModules.get(deployRequest.getMavenArtifactId());
        boolean sameVersion = installedModule.getString("maven_version").equals(deployRequest.getSnapshotVersion() != null ? deployRequest.getSnapshotVersion() : deployRequest.getVersion());
        if (sameVersion) {
            LOG.info("[{} - {}]: Module ({}) already installed.", new Object[]{"DeployRequest", deployRequest.getId(), deployRequest.getModuleId()});
        }
        return sameVersion ? ModuleVersion.INSTALLED : ModuleVersion.OLDER_VERSION;
    }

    public void stopContainer(String requestId) {
        InvokeContainer invokeContainer = new InvokeContainer(requestId, this.config);
        this.installedModules.entrySet().stream().map(Map.Entry::getValue).forEach(module -> {
            invokeContainer.withArgs(module.getString("application_id"));
            invokeContainer.execute("stop");
        });
    }
}

