/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadArtifact
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadArtifact.class);
    private final DeployConfig config;

    public DownloadArtifact(DeployConfig config) {
        this.config = config;
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (this.config.isHttpAuthentication()) {
            credsProvider.setCredentials(new AuthScope(this.config.getNexusUrl().getHost(), "https".equals(this.config.getNexusUrl().getScheme()) ? 443 : 80), (Credentials)new UsernamePasswordCredentials(this.config.getHttpAuthUser(), this.config.getHttpAuthPassword()));
        }
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        boolean downloaded = false;
        HttpGet get = new HttpGet(this.config.getNexusUrl().resolve(this.config.getNexusUrl().getPath() + "/" + request.getRemoteLocation()));
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);){
            if (response.getStatusLine().getStatusCode() == HttpResponseStatus.OK.code()) {
                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(new File(this.config.getArtifactRepo() + request.getFileName())));
                response.getEntity().writeTo((OutputStream)fos);
                response.close();
                ((OutputStream)fos).close();
                LOG.info("[{} - {}]: Downloaded artifact {} to {}.", new Object[]{"Deploy SiteRequest", request.getId(), request.getModuleId(), this.config.getArtifactRepo() + request.getModuleId() + "." + request.getType()});
                downloaded = true;
            } else {
                LOG.error("[{} - {}]: Error downloading artifact {}.", new Object[]{"Deploy SiteRequest", request.getId(), request.getModuleId()});
                LOG.error("[{} - {}]: HttpClient Error [{}] -> {}.", new Object[]{"Deploy SiteRequest", request.getId(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
            }
        }
        catch (IOException e) {
            LOG.error("[{} - {}]: IOException while Error downloading artifact {}. Reason '{}'", new Object[]{"Deploy SiteRequest", request.getId(), request.getArtifactId(), e.getMessage()});
        }
        return new JsonObject().put("success", Boolean.valueOf(downloaded));
    }
}

