/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.net.URI;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.util.MetadataXPathUtil;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveSnapshotVersion
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ResolveSnapshotVersion.class);
    private final DeployConfig config;
    private final String logId;

    public ResolveSnapshotVersion(DeployConfig config, String logId) {
        this.config = config;
        this.logId = logId;
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (this.config.isHttpAuthentication()) {
            credsProvider.setCredentials(new AuthScope(this.config.getNexusUrl().getHost(), "https".equals(this.config.getNexusUrl().getScheme()) ? 443 : 80), (Credentials)new UsernamePasswordCredentials(this.config.getHttpAuthUser(), this.config.getHttpAuthPassword()));
        }
        boolean resolved = false;
        String realSnapshotVersion = request.isSnapshot() ? request.getVersion() : null;
        try (CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();){
            if (request.isSnapshot()) {
                LOG.info("[{} - {}]: Artifact is -SNAPSHOT, trying to parse metadata for last version {}.", new Object[]{this.logId, request.getId(), request.getModuleId()});
                realSnapshotVersion = this.retrieveAndParseMetadata(request, httpclient, this.config.getNexusUrl());
                if (realSnapshotVersion != null) {
                    LOG.info("[{} - {}]: Parsed metadata. Snapshot version is {} ", new Object[]{this.logId, request.getId(), realSnapshotVersion});
                }
            }
        }
        catch (IOException e) {
            LOG.error("[{} - {}]: IO Exception while downloading artifact {}. Reason '{}'.", new Object[]{this.logId, request.getId(), request.getArtifactId(), e.getMessage()});
        }
        return new JsonObject().put("success", Boolean.valueOf(resolved)).put("version", realSnapshotVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String retrieveAndParseMetadata(ModuleRequest request, CloseableHttpClient httpclient, URI repoUri) {
        HttpGet getMetadata = new HttpGet(repoUri.resolve(repoUri.getPath() + "/" + request.getMetadataLocation()));
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)getMetadata);){
            String result;
            if (response.getStatusLine().getStatusCode() != HttpResponseStatus.OK.code()) {
                LOG.error("[{} - {}]: No metadata found for module {} with error code {} with request {}", new Object[]{this.logId, request.getId(), request.getModuleId(), response.getStatusLine().getStatusCode(), getMetadata.getURI()});
                String string2 = null;
                return string2;
            }
            byte[] metadata = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            response.close();
            String string = result = MetadataXPathUtil.getRealSnapshotVersionFromMetadata(metadata, request);
            return string;
        }
        catch (IOException e) {
            LOG.error("[{} - {}]: Error while downloading metadata for module {} : {}", new Object[]{this.logId, request.getId(), request.getModuleId(), e.getMessage()});
            return null;
        }
    }
}

