/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.json.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunModule
implements Command<ModuleRequest> {
    private static final String JAVA_OPTS = "JAVA_OPTS";
    private static final String INSTANCES = "INSTANCES";
    private static final Logger LOG = LoggerFactory.getLogger(RunModule.class);
    private static final String UUID_PATTERN = "[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}";
    private boolean success = false;
    private FileSystem fs;
    private DeployConfig config;

    public RunModule(FileSystem fs, DeployConfig config) {
        this.fs = fs;
        this.config = config;
    }

    public String buildRemoteRepo() {
        URI remoteRepo = this.config.getNexusUrl();
        if (remoteRepo != null && this.config.isHttpAuthentication()) {
            URIBuilder builder = new URIBuilder(remoteRepo);
            builder.setUserInfo(this.config.getHttpAuthUser() + ":" + this.config.getHttpAuthPassword());
            return builder.toString();
        }
        return null;
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        LOG.info("[{} - {}]: Running module '{}'", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId()});
        String applicationID = this.startWithInit(request);
        return new JsonObject().put("deploy_id", request.getId().toString()).put("maven_id", request.getMavenArtifactId()).put("maven_version", request.getSnapshotVersion() == null ? request.getVersion() : request.getSnapshotVersion()).put("application_id", applicationID).put("success", Boolean.valueOf(this.success));
    }

    public String startWithInit(ModuleRequest request) {
        String applicationId = request.getModuleId();
        Properties serviceProperties = this.readServiceDefaults(request);
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.addAll(Arrays.asList(this.config.getVertxHome().resolve("bin/vertx").toString(), "start", "maven:" + request.getModuleId(), "-id", request.getModuleId()));
            if (!this.config.isMavenLocal()) {
                command.add("-Dvertx.maven.remoteRepos=" + this.buildRemoteRepo());
            }
            if (!this.config.getConfigLocation().isEmpty()) {
                command.add("-conf");
                command.add(this.config.getConfigLocation());
            }
            if (serviceProperties.containsKey(JAVA_OPTS)) {
                command.add("--java-opts");
                command.add(serviceProperties.getProperty(JAVA_OPTS));
            }
            command.add("--instances");
            command.add((String)serviceProperties.getOrDefault((Object)INSTANCES, "1"));
            Process runProcess = Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
            runProcess.waitFor(1L, TimeUnit.MINUTES);
            int exitValue = runProcess.exitValue();
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(runProcess.getErrorStream()));
                LOG.info("[{} - {}]: {} - Error Starting module '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error(errorLine);
                }
            }
            if (exitValue == 0) {
                String outLine;
                this.success = true;
                BufferedReader out = new BufferedReader(new InputStreamReader(runProcess.getInputStream()));
                while ((outLine = out.readLine()) != null) {
                    if (!outLine.matches(UUID_PATTERN)) continue;
                    applicationId = outLine;
                }
                LOG.info("[{} - {}]: Started module '{}' with applicationID '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId(), applicationId});
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to initialize module {} with error '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        }
        return applicationId;
    }

    private Properties readServiceDefaults(ModuleRequest request) {
        Properties serviceProperties = new Properties();
        String path = "/etc/default/" + request.getGroupId() + ":" + request.getArtifactId();
        if (this.fs.existsBlocking(path)) {
            Buffer b = this.fs.readFileBlocking("/etc/default/" + request.getGroupId() + ":" + request.getArtifactId());
            try {
                serviceProperties.load(new ByteArrayInputStream(b.getBytes()));
            }
            catch (IOException e) {
                LOG.error("[{} - {}]: Failed to initialize properties for module  {} with error '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId(), e.getMessage()});
            }
        }
        return serviceProperties;
    }
}

