/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import nl.jpoint.vertx.mod.deploy.handler.RestDeployModuleHandler;
import nl.jpoint.vertx.mod.deploy.request.DeployArtifactRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployConfigRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployModuleRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import nl.jpoint.vertx.mod.deploy.service.AwsService;
import nl.jpoint.vertx.mod.deploy.service.DeployModuleService;
import nl.jpoint.vertx.mod.deploy.service.DeployService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RestDeployHandler
implements Handler<RoutingContext> {
    private final DeployService<DeployModuleRequest> moduleDeployService;
    private final DeployService<DeployArtifactRequest> artifactDeployService;
    private final DeployService<DeployConfigRequest> configDeployService;
    private final AwsService awsService;
    private final Logger LOG = LoggerFactory.getLogger(RestDeployModuleHandler.class);

    public RestDeployHandler(DeployService<DeployModuleRequest> moduleDeployService, DeployService<DeployArtifactRequest> artifactDeployService, DeployService<DeployConfigRequest> configDeployService, AwsService awsService) {
        MDC.put((String)"service", (String)"deploy");
        this.moduleDeployService = moduleDeployService;
        this.artifactDeployService = artifactDeployService;
        this.configDeployService = configDeployService;
        this.awsService = awsService;
    }

    public void handle(RoutingContext context) {
        context.request().bodyHandler(buffer -> {
            DeployRequest deployRequest;
            ObjectReader reader = new ObjectMapper().readerFor(DeployRequest.class);
            String eventBody = new String(buffer.getBytes());
            if (eventBody.isEmpty()) {
                this.LOG.error("{}: No postdata in request.", (Object)"DeployRequest");
                this.respondFailed(context.request());
                return;
            }
            this.LOG.debug("{}: received postdata -> {} ", (Object)"DeployRequest", (Object)eventBody);
            try {
                deployRequest = (DeployRequest)reader.readValue(eventBody);
            }
            catch (IOException e) {
                this.LOG.error("{}: Error while reading postdata -> {}.", (Object)"DeployRequest", (Object)e.getMessage());
                this.respondFailed(context.request());
                return;
            }
            this.LOG.info("[{} - {}]: Received deploy request with {} config(s), {} module(s) and {} artifact(s) ", new Object[]{"DeployRequest", deployRequest.getId().toString(), deployRequest.getConfigs() != null ? deployRequest.getConfigs().size() : 0, deployRequest.getModules() != null ? deployRequest.getModules().size() : 0, deployRequest.getArtifacts() != null ? deployRequest.getArtifacts().size() : 0});
            JsonObject deployOk = null;
            if (deployRequest.withElb()) {
                if (this.awsService != null && this.awsService.registerRequest(deployRequest)) {
                    this.respondContinue(context.request(), deployRequest.getId().toString());
                    this.awsService.deRegisterInstance(deployRequest.getId().toString());
                } else {
                    this.LOG.error("{}: Failed to register aws request or aws service disabled.", (Object)"DeployRequest");
                    this.respondFailed(context.request());
                }
                return;
            }
            if (deployRequest.getConfigs() != null && !deployRequest.getConfigs().isEmpty()) {
                for (DeployConfigRequest configRequest : deployRequest.getConfigs()) {
                    deployOk = this.configDeployService.deploy(configRequest);
                    if (!deployOk.getBoolean("result").booleanValue()) {
                        this.respondFailed(context.request());
                        return;
                    }
                    if (deployRequest.withRestart() || !deployOk.getBoolean("configChanged", Boolean.valueOf(false)).booleanValue()) continue;
                    deployRequest.setRestart(true);
                }
            }
            if (deployRequest.withRestart()) {
                ((DeployModuleService)this.moduleDeployService).stopContainer(deployRequest.getId().toString());
            }
            if (deployRequest.getArtifacts() != null && !deployRequest.getArtifacts().isEmpty()) {
                for (DeployArtifactRequest artifactRequest : deployRequest.getArtifacts()) {
                    deployOk = this.artifactDeployService.deploy(artifactRequest);
                    if (deployOk.getBoolean("result").booleanValue()) continue;
                    this.respondFailed(context.request());
                    return;
                }
            }
            if (deployRequest.getModules() != null && !deployRequest.getModules().isEmpty()) {
                for (DeployModuleRequest moduleRequest : deployRequest.getModules()) {
                    deployOk = this.moduleDeployService.deploy(moduleRequest);
                    if (deployOk.getBoolean("result").booleanValue()) continue;
                    this.respondFailed(context.request());
                    return;
                }
            }
            this.respondOk(context.request());
        });
    }

    private void respondOk(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        request.response().end();
    }

    private void respondContinue(HttpServerRequest request, String id) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        request.response().setStatusMessage(id);
        request.response().end(id);
    }

    private void respondFailed(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        request.response().end();
    }
}

