/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import io.vertx.core.file.FileSystem;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.InvokeContainer;
import nl.jpoint.vertx.mod.deploy.command.ResolveSnapshotVersion;
import nl.jpoint.vertx.mod.deploy.command.RunModule;
import nl.jpoint.vertx.mod.deploy.command.StopModule;
import nl.jpoint.vertx.mod.deploy.request.DeployModuleRequest;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployService;
import nl.jpoint.vertx.mod.deploy.util.ModuleVersion;
import nl.jpoint.vertx.mod.deploy.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployModuleService
implements DeployService<DeployModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DeployModuleService.class);
    private final DeployConfig config;
    private FileSystem fs;
    private final Map<String, JsonObject> installedModules;

    public DeployModuleService(DeployConfig config, FileSystem fs) {
        this.config = config;
        this.fs = fs;
        this.installedModules = new ProcessUtils(config).listInstalledAndRunningModules();
    }

    @Override
    public JsonObject deploy(DeployModuleRequest deployRequest) {
        JsonObject runResult;
        RunModule runModCommand;
        ModuleVersion moduleInstalled;
        ResolveSnapshotVersion resolveVersion;
        JsonObject result;
        if (deployRequest.isSnapshot() && !this.config.isMavenLocal() && (result = (resolveVersion = new ResolveSnapshotVersion(this.config, "DeployRequest")).execute(deployRequest)).getBoolean("success").booleanValue()) {
            deployRequest.setSnapshotVersion(result.getString("version"));
        }
        if ((moduleInstalled = this.moduleInstalled(deployRequest)).equals((Object)ModuleVersion.ERROR)) {
            return new JsonObject().put("result", Boolean.valueOf(false));
        }
        if (moduleInstalled.equals((Object)ModuleVersion.INSTALLED)) {
            if (deployRequest.restart()) {
                runModCommand = new RunModule(this.fs, this.config);
                runModCommand.execute(deployRequest);
            }
            return new JsonObject().put("result", Boolean.valueOf(true));
        }
        if (!moduleInstalled.equals((Object)ModuleVersion.INSTALLED) && moduleInstalled.equals((Object)ModuleVersion.OLDER_VERSION)) {
            StopModule stopModuleCommand;
            JsonObject result2;
            if (!deployRequest.restart() && !(result2 = (stopModuleCommand = new StopModule(this.config).forApplicationId(this.installedModules.get(deployRequest.getMavenArtifactId()).getString("application_id"))).execute(deployRequest)).getBoolean("module_stopped").booleanValue()) {
                return new JsonObject().put("result", Boolean.valueOf(false));
            }
            this.installedModules.remove(deployRequest.getMavenArtifactId());
        }
        if (!(runResult = (runModCommand = new RunModule(this.fs, this.config)).execute(deployRequest)).getBoolean("success").booleanValue()) {
            return new JsonObject().put("result", Boolean.valueOf(false));
        }
        this.installedModules.put(deployRequest.getMavenArtifactId(), runResult);
        return new JsonObject().put("result", Boolean.valueOf(true));
    }

    private ModuleVersion moduleInstalled(ModuleRequest deployRequest) {
        if (!this.installedModules.containsKey(deployRequest.getMavenArtifactId())) {
            LOG.info("[{} - {}]: Module ({}) not installed.", new Object[]{"DeployRequest", deployRequest.getId(), deployRequest.getModuleId()});
            return ModuleVersion.NOT_INSTALLED;
        }
        JsonObject installedModule = this.installedModules.get(deployRequest.getMavenArtifactId());
        boolean sameVersion = installedModule.getString("maven_version").equals(deployRequest.getSnapshotVersion() != null ? deployRequest.getSnapshotVersion() : deployRequest.getVersion());
        if (sameVersion) {
            if (!this.checkModuleRunning(deployRequest)) {
                LOG.info("[{} - {}]: Module ({}) stopped externally.", new Object[]{"DeployRequest", deployRequest.getId(), deployRequest.getModuleId()});
                return ModuleVersion.NOT_INSTALLED;
            }
            LOG.info("[{} - {}]: Module ({}) already installed.", new Object[]{"DeployRequest", deployRequest.getId(), deployRequest.getModuleId()});
        }
        return sameVersion ? ModuleVersion.INSTALLED : ModuleVersion.OLDER_VERSION;
    }

    private boolean checkModuleRunning(ModuleRequest deployRequest) {
        return new ProcessUtils(this.config).checkModuleRunning(deployRequest.getModuleId());
    }

    public void stopContainer(String requestId) {
        InvokeContainer invokeContainer = new InvokeContainer(requestId, this.config);
        this.installedModules.entrySet().stream().map(Map.Entry::getValue).forEach(module -> {
            invokeContainer.withArgs(module.getString("application_id"));
            invokeContainer.execute("stop");
        });
    }
}

