/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileDigestUtil {
    private MessageDigest md;

    public FileDigestUtil() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            this.md = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getFileMd5Sum(Path unpackFile) {
        if (this.md == null) return null;
        if (Files.notExists(unpackFile, new LinkOption[0])) {
            return null;
        }
        try (InputStream is = Files.newInputStream(unpackFile, new OpenOption[0]);){
            DigestInputStream dis = new DigestInputStream(is, this.md);
            while (dis.read() != -1) {
            }
            byte[] digest = this.md.digest();
            this.md.reset();
            byte[] byArray = digest;
            return byArray;
        }
        catch (IOException e) {
            return null;
        }
    }
}

