/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.util;

import io.vertx.core.json.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessUtils.class);
    private static final String UUID_PATTERN = "([^\\s]+):([^\\s]+):([^\\s]+)";
    private static final String MAVEN_PATTERN = "maven:([^\\s]+)";
    private final Path vertxHome;
    private final Pattern pattern;

    public ProcessUtils(DeployConfig config) {
        this.vertxHome = config.getVertxHome();
        this.pattern = Pattern.compile(MAVEN_PATTERN);
    }

    public Map<String, JsonObject> listInstalledAndRunningModules() {
        List<String> moduleIds = this.listModules();
        return moduleIds.stream().map(this::describeModule).collect(Collectors.toMap(jsonObject -> jsonObject.getString("maven_id"), Function.identity()));
    }

    private JsonObject describeModule(String applicationId) {
        JsonObject module = new JsonObject();
        String moduleString = "";
        try {
            Process describeProcess = Runtime.getRuntime().exec(new String[]{"pgrep", "-a", "-f", applicationId});
            describeProcess.waitFor(1L, TimeUnit.MINUTES);
            int exitValue = describeProcess.exitValue();
            if (exitValue == 0) {
                String outLine;
                BufferedReader out = new BufferedReader(new InputStreamReader(describeProcess.getInputStream()));
                while ((outLine = out.readLine()) != null) {
                    Matcher matcher = this.pattern.matcher(outLine);
                    if (!matcher.find()) continue;
                    moduleString = matcher.group(1);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{}]: -  Failed to list modules '{}'", (Object)"Startup", (Object)e.getMessage());
        }
        this.parseModuleString(module, moduleString, applicationId);
        return module;
    }

    private void parseModuleString(JsonObject module, String moduleString, String applicationId) {
        String[] vars;
        if (moduleString != null && !moduleString.isEmpty() && (vars = moduleString.split(":", 3)).length == 3) {
            module.put("maven_version", vars[2]);
            module.put("maven_id", vars[0] + ":" + vars[1]);
            module.put("application_id", applicationId);
        }
    }

    private List<String> listModules() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Process listProcess = Runtime.getRuntime().exec(new String[]{this.vertxHome.resolve("bin/vertx").toString(), "list"});
            listProcess.waitFor(1L, TimeUnit.MINUTES);
            int exitValue = listProcess.exitValue();
            if (exitValue == 0) {
                String outLine;
                BufferedReader out = new BufferedReader(new InputStreamReader(listProcess.getInputStream()));
                while ((outLine = out.readLine()) != null) {
                    if (!outLine.matches(UUID_PATTERN)) continue;
                    result.add(outLine);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{}]: -  Failed to list modules '{}'", (Object)"Startup", (Object)e.getMessage());
        }
        return result;
    }

    public boolean checkModuleRunning(String moduleId) {
        JsonObject module = this.describeModule(moduleId);
        return !module.isEmpty();
    }
}

