/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.handler.internal;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import nl.jpoint.vertx.mod.deploy.aws.AwsElbUtil;
import nl.jpoint.vertx.mod.deploy.aws.AwsException;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsElbRegistrationStatusPollingHandler
implements Handler<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(AwsElbRegistrationStatusPollingHandler.class);
    private final DeployRequest request;
    private final AwsElbUtil elbUtil;
    private final Vertx vertx;
    private final AwsState state;

    public AwsElbRegistrationStatusPollingHandler(DeployRequest request, AwsElbUtil elbUtil, Vertx vertx, AwsState state) {
        this.request = request;
        this.elbUtil = elbUtil;
        this.vertx = vertx;
        this.state = state;
        LOG.info("[{} - {}]: Waiting for instance {} status on loadbalancer {} to reach {}.", new Object[]{"ConfigureAwsElb", request.getId(), elbUtil.forInstanceId(), elbUtil.forLoadbalancer(), state});
    }

    public void handle(Long timer) {
        try {
            AwsState currentState = this.elbUtil.getInstanceState();
            LOG.info("[{} - {}]: Instance {} on loadbalancer {} in state {}", new Object[]{"ConfigureAwsElb", this.request.getId(), this.elbUtil.forInstanceId(), this.elbUtil.forLoadbalancer(), currentState.name()});
            if (this.state.equals((Object)currentState)) {
                this.vertx.cancelTimer(timer.longValue());
                this.vertx.eventBus().send("aws.service.deploy", (Object)new JsonObject().put("success", Boolean.valueOf(true)).put("id", this.request.getId().toString()).put("state", this.state.toString()));
            }
        }
        catch (AwsException e) {
            LOG.error("[{} - {}]: Error executing de-register", new Object[]{"ConfigureAwsElb", this.request.getId(), e.getMessage()});
        }
    }
}

