/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws.state;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.List;
import nl.jpoint.vertx.mod.deploy.aws.AwsElbUtil;
import nl.jpoint.vertx.mod.deploy.aws.AwsException;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.handler.internal.AwsElbRegistrationStatusPollingHandler;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsElbDeRegisterInstance
implements Command<DeployRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AwsElbDeRegisterInstance.class);
    private final Vertx vertx;
    private final AwsElbUtil awsElbUtil;

    protected AwsElbDeRegisterInstance(Vertx vertx, AwsElbUtil awsElbUtil) {
        this.vertx = vertx;
        this.awsElbUtil = awsElbUtil;
    }

    @Override
    public JsonObject execute(DeployRequest request) {
        try {
            List<String> instances = this.awsElbUtil.listLBInstanceMembers();
            if (!instances.contains(this.awsElbUtil.forInstanceId())) {
                LOG.info("[{} - {}]: Instance {} not registered with loadbalancer {}.", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.forInstanceId(), this.awsElbUtil.forLoadbalancer()});
                this.vertx.eventBus().send("aws.service.deploy", (Object)new JsonObject().put("success", Boolean.valueOf(true)).put("id", request.getId().toString()).put("state", AwsState.NOTREGISTERED.name()));
                return new JsonObject().put("success", Boolean.valueOf(true));
            }
            if (this.awsElbUtil.deRegisterInstanceFromLoadbalancer()) {
                LOG.info("[{} - {}]: Failed to de-register Instance {} from loadbalancer {}.", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.forInstanceId(), this.awsElbUtil.forLoadbalancer()});
                return new JsonObject().put("success", Boolean.valueOf(false));
            }
            LOG.info("[{} - {}]: Starting instance status poller for instance id {} on loadbalancer {}", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.forInstanceId(), this.awsElbUtil.forLoadbalancer()});
            this.vertx.setPeriodic(3000L, (Handler)new AwsElbRegistrationStatusPollingHandler(request, this.awsElbUtil, this.vertx, AwsState.OUTOFSERVICE));
        }
        catch (AwsException e) {
            LOG.error("[{} - {}]: Error de-register instance {} from loadbalancer {}.", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.forInstanceId(), this.awsElbUtil.forLoadbalancer()});
            return new JsonObject().put("success", Boolean.valueOf(false));
        }
        return new JsonObject().put("success", Boolean.valueOf(true));
    }
}

